/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.reminders;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.skyblock.IslandType;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.event.ChatEvents;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.manager.reminder.Reminder;
import fr.siroz.cariboustonks.manager.reminder.ReminderDisplay;
import fr.siroz.cariboustonks.manager.reminder.ReminderManager;
import fr.siroz.cariboustonks.manager.reminder.TimedObject;
import fr.siroz.cariboustonks.util.Client;
import fr.siroz.cariboustonks.util.StonksUtils;
import fr.siroz.cariboustonks.util.render.notification.Notification;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EnchantedCloakReminderFeature
extends Feature
implements Reminder {
    private static final Pattern CHAT_BOOST_USED_PATTERN = Pattern.compile("TIME WARP! You have successfully warped time for your (?<type>.+?)!");
    private static final class_1799 ICON = new class_1799((class_1935)class_1802.field_8557);

    public EnchantedCloakReminderFeature() {
        ChatEvents.MESSAGE_RECEIVED.register(this::onChatMessage);
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock() && SkyBlockAPI.getIsland() != IslandType.DUNGEON && ConfigManager.getConfig().general.reminders.enchantedCloak;
    }

    @Override
    @NotNull
    public String reminderType() {
        return "ENCHANTED_CLOAK";
    }

    @Override
    @NotNull
    public ReminderDisplay display() {
        return ReminderDisplay.of((class_2561)class_2561.method_43470((String)"Enchanted Cloak").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067, class_124.field_1073}), null, ICON);
    }

    @Override
    public void onExpire(@NotNull TimedObject timedObject) {
        BoostType boostType = BoostType.getByName(timedObject.id().replace("cloak::", ""));
        if (boostType == null) {
            return;
        }
        class_5250 text = class_2561.method_43473().method_10852(boostType.name).method_10852((class_2561)class_2561.method_43470((String)" is ready!").method_27692(class_124.field_1060));
        Client.sendMessageWithPrefix((class_2561)class_2561.method_43470((String)"[Enchanted Cloak] ").method_27692(class_124.field_1065).method_10852((class_2561)text));
        Notification.show(class_2561.method_43470((String)"Enchanted Cloak !\n").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}).method_10852((class_2561)text), ICON);
    }

    private void onChatMessage(@NotNull class_2561 text) {
        String type;
        BoostType boostType;
        if (!this.isEnabled()) {
            return;
        }
        Matcher chatBoostTypeMatcher = CHAT_BOOST_USED_PATTERN.matcher(text.getString());
        if (chatBoostTypeMatcher.matches() && (boostType = BoostType.getById(type = chatBoostTypeMatcher.group("type"))) != null) {
            String message = StonksUtils.textToJson(boostType.name).orElse(boostType.name.getString());
            TimedObject timedObject = new TimedObject("cloak::" + boostType.name(), message, Instant.now().plus(Duration.ofHours(48L)), this.reminderType());
            CaribouStonks.managers().getManager(ReminderManager.class).addTimedObject(timedObject);
        }
    }

    private static enum BoostType {
        MINIONS("Minions", (class_2561)class_2561.method_43470((String)"Minions").method_27692(class_124.field_1075)),
        CHOCOLATE_FACTORY("Chocolate Factory", (class_2561)class_2561.method_43470((String)"Chocolate Factory").method_27692(class_124.field_1065)),
        PET_TRAINING("Pet Training", (class_2561)class_2561.method_43470((String)"Pet Training").method_27692(class_124.field_1076)),
        PET_SITTER("Pet Sitter", (class_2561)class_2561.method_43470((String)"Pet Sitter").method_27692(class_124.field_1061)),
        AGING_ITEMS("Aging Items", (class_2561)class_2561.method_43470((String)"Aging Items").method_27692(class_124.field_1054)),
        FORGE("Forges", (class_2561)class_2561.method_43470((String)"Forge").method_27692(class_124.field_1065));

        private final String id;
        private final class_2561 name;

        private BoostType(String id, class_2561 name) {
            this.id = id;
            this.name = name;
        }

        @Nullable
        static BoostType getById(@NotNull String id) {
            return Arrays.stream(BoostType.values()).filter(boostType -> boostType.id.equals(id)).findFirst().orElse(null);
        }

        @Nullable
        static BoostType getByName(@NotNull String name) {
            return Arrays.stream(BoostType.values()).filter(boostType -> boostType.name().equalsIgnoreCase(name)).findFirst().orElse(null);
        }
    }
}

