/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.reminders;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.manager.container.ContainerMatcherTrait;
import fr.siroz.cariboustonks.manager.container.overlay.ContainerOverlay;
import fr.siroz.cariboustonks.manager.reminder.Reminder;
import fr.siroz.cariboustonks.manager.reminder.ReminderDisplay;
import fr.siroz.cariboustonks.manager.reminder.ReminderManager;
import fr.siroz.cariboustonks.manager.reminder.TimedObject;
import fr.siroz.cariboustonks.util.Client;
import fr.siroz.cariboustonks.util.ItemUtils;
import fr.siroz.cariboustonks.util.StonksUtils;
import fr.siroz.cariboustonks.util.render.gui.ColorHighlight;
import fr.siroz.cariboustonks.util.render.notification.Notification;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ForgeReminderFeature
extends Feature
implements ContainerMatcherTrait,
Reminder,
ContainerOverlay {
    private static final Pattern TITLE_PATTERN = Pattern.compile("^The Forge");
    private static final class_1799 ICON = new class_1799((class_1935)class_1802.field_8732);

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock() && ConfigManager.getConfig().general.reminders.forge;
    }

    @Override
    public Pattern getTitlePattern() {
        return TITLE_PATTERN;
    }

    @Override
    @NotNull
    public String reminderType() {
        return "FORGE_ITEM";
    }

    @Override
    @NotNull
    public ReminderDisplay display() {
        return ReminderDisplay.of((class_2561)class_2561.method_43470((String)"Forge").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067, class_124.field_1073}), null, ICON);
    }

    @Override
    public void onExpire(@NotNull TimedObject timedObject) {
        class_2561 text = StonksUtils.jsonToText(timedObject.message()).orElse((class_2561)class_2561.method_43470((String)timedObject.message()));
        Client.sendMessageWithPrefix((class_2561)class_2561.method_43470((String)"[Forge] ").method_27692(class_124.field_1065).method_10852(text).method_10852((class_2561)class_2561.method_43470((String)" was ended!").method_27692(class_124.field_1060)));
        Notification.show(class_2561.method_43470((String)"Forge !\n").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}).method_10852(text).method_27693("\n").method_10852((class_2561)class_2561.method_43470((String)"was ended").method_27692(class_124.field_1060)), ICON);
    }

    @Override
    @NotNull
    public List<ColorHighlight> content(@NotNull Int2ObjectMap<class_1799> slots) {
        ArrayList<ColorHighlight> highlights = new ArrayList<ColorHighlight>();
        for (Int2ObjectMap.Entry entry : slots.int2ObjectEntrySet()) {
            class_1799 itemStack = (class_1799)entry.getValue();
            if (itemStack.method_31574(class_1802.field_8732)) {
                highlights.add(ColorHighlight.green(entry.getIntKey(), 0.5f));
                continue;
            }
            String lore = ItemUtils.getLoreLineIf(itemStack, s -> s.contains("Time"));
            if (lore == null) continue;
            String timeRemaining = lore.replace("Time Remaining: ", "");
            int[] time = this.extractTime(timeRemaining);
            int hours = time[0];
            int minutes = time[1];
            int seconds = time[2];
            if (hours == 0 && minutes == 0 && seconds == 0) continue;
            String text = StonksUtils.textToJson(itemStack.method_7964()).orElse(itemStack.method_7964().getString());
            Duration duration = Duration.ofHours(hours).plusMinutes(minutes).plusSeconds(seconds);
            Instant expirationTime = Instant.now().plus(duration);
            TimedObject timedObject = new TimedObject("forge::" + entry.getIntKey(), text, expirationTime, this.reminderType());
            CaribouStonks.managers().getManager(ReminderManager.class).addTimedObject(timedObject, true);
        }
        return highlights;
    }

    @Contract(value="_ -> new")
    private int @NotNull [] extractTime(@NotNull String input) {
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        try {
            String[] parts;
            for (String part : parts = input.split(" ")) {
                if (part.endsWith("h")) {
                    hours = Integer.parseInt(part.replace("h", ""));
                    continue;
                }
                if (part.endsWith("m")) {
                    minutes = Integer.parseInt(part.replace("m", ""));
                    continue;
                }
                if (!part.endsWith("s")) continue;
                seconds = Integer.parseInt(part.replace("s", ""));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new int[]{hours, minutes, seconds};
    }
}

