/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.stonks;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.data.algo.BazaarItemAnalytics;
import fr.siroz.cariboustonks.core.data.hypixel.HypixelDataSource;
import fr.siroz.cariboustonks.core.data.hypixel.SkyBlockItem;
import fr.siroz.cariboustonks.core.data.hypixel.bazaar.Product;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.manager.command.CommandRegistration;
import fr.siroz.cariboustonks.util.Client;
import fr.siroz.cariboustonks.util.StonksUtils;
import fr.siroz.cariboustonks.util.Symbols;
import fr.siroz.cariboustonks.util.colors.Colors;
import java.util.Optional;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3417;
import net.minecraft.class_7157;
import org.jetbrains.annotations.NotNull;

public class StonksCommandFeature
extends Feature
implements CommandRegistration {
    private static final String SEPARATOR = "\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac";
    private final HypixelDataSource hypixelDataSource = CaribouStonks.core().getHypixelDataSource();

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock();
    }

    @Override
    public void register(@NotNull CommandDispatcher<FabricClientCommandSource> dispatcher, @NotNull class_7157 _ra) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"stonks").then(ClientCommandManager.argument((String)"item", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(this.hypixelDataSource.getSkyBlockItemsIds(), (SuggestionsBuilder)builder)).executes(context -> this.handle((FabricClientCommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"item")))));
    }

    private int handle(FabricClientCommandSource source, String item) {
        int result = 1;
        if (this.hypixelDataSource.isBazaarInUpdate()) {
            source.sendFeedback((class_2561)class_2561.method_43470((String)"Bazaar is currently updating.. Retry in few seconds.").method_27692(class_124.field_1061));
            return result;
        }
        if (!this.hypixelDataSource.hasBazaarItem(item)) {
            source.sendFeedback((class_2561)class_2561.method_43470((String)("Unable to find '" + item + "' item in the Bazaar.")).method_27692(class_124.field_1061));
            return result;
        }
        Optional<Product> productOptional = this.hypixelDataSource.getBazaarItem(item);
        if (productOptional.isPresent()) {
            Product product = productOptional.get();
            Client.playSound(class_3417.field_50098, 1.0f, 1.0f);
            source.sendFeedback((class_2561)class_2561.method_43470((String)SEPARATOR).method_27692(class_124.field_1061));
            SkyBlockItem skyBlockItem = this.hypixelDataSource.getSkyBlockItem(item);
            if (skyBlockItem == null) {
                source.sendFeedback((class_2561)class_2561.method_43473().method_10852(Symbols.getStyled("\u2b50", Colors.ORANGE.asInt(), new class_124[0])).method_27693(" " + String.valueOf(class_2561.method_43470((String)(product.productId() + " :")).method_27692(class_124.field_1065))));
            } else {
                source.sendFeedback((class_2561)class_2561.method_43473().method_10852(Symbols.getStyled("\u2b50", Colors.ORANGE.asInt(), new class_124[0])).method_10852((class_2561)class_2561.method_43470((String)(" " + skyBlockItem.getName())).method_54663(skyBlockItem.getTier().getColor())).method_10852((class_2561)class_2561.method_43470((String)(" (" + product.productId() + ")")).method_27692(class_124.field_1063)));
            }
            source.sendFeedback((class_2561)class_2561.method_43473());
            double buyPrice = BazaarItemAnalytics.buyPrice(product);
            double buyAvgPrice = BazaarItemAnalytics.weightedAverageBuyPrice(product);
            double vwap = BazaarItemAnalytics.vwap(product);
            double standardDeviationBuy = BazaarItemAnalytics.standardDeviation(product.buySummary());
            source.sendFeedback((class_2561)class_2561.method_43470((String)"Buy: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(StonksUtils.INTEGER_NUMBERS.format(buyPrice) + " Coins")).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(buyPrice)).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)" (Hover)").method_27692(class_124.field_1075)).method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Buy-Avg: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(StonksUtils.INTEGER_NUMBERS.format(buyAvgPrice) + " Coins")).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(buyAvgPrice)).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"\n\n")).method_10852((class_2561)class_2561.method_43470((String)"*VWAP: ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(vwap)).method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43470((String)"(An average that takes into account the volumes of each order)").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)"\n\n")).method_10852((class_2561)class_2561.method_43470((String)"*Standard Deviation: ").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(standardDeviationBuy)).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43470((String)"(This measures price volatility. Higher values indicate stronger fluctuations)").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)"\n\n")).method_10852((class_2561)class_2561.method_43470((String)"* Not a true representation of all orders").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}))))));
            long buyVolume = product.quickStatus().buyVolume();
            long buyOrders = product.quickStatus().buyOrders();
            long buyMovingWeek = product.quickStatus().buyMovingWeek();
            source.sendFeedback((class_2561)class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(buyVolume)).method_27692(class_124.field_1063).method_27693(" in " + StonksUtils.SHORT_FLOAT_NUMBERS.format(buyOrders) + " orders").method_10852((class_2561)class_2561.method_43470((String)" | ").method_27692(class_124.field_1080)).method_27693(StonksUtils.SHORT_FLOAT_NUMBERS.format(buyMovingWeek)).method_27692(class_124.field_1063).method_10852((class_2561)class_2561.method_43470((String)" insta-buys in 7d").method_27692(class_124.field_1063)));
            source.sendFeedback((class_2561)class_2561.method_43473());
            double sellPrice = BazaarItemAnalytics.sellPrice(product);
            double sellAvgPrice = BazaarItemAnalytics.weightedAverageSellPrice(product);
            double standardDeviationSell = BazaarItemAnalytics.standardDeviation(product.sellSummary());
            source.sendFeedback((class_2561)class_2561.method_43470((String)"Sell: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(StonksUtils.INTEGER_NUMBERS.format(sellPrice) + " Coins")).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(sellPrice)).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)" (Hover)").method_27692(class_124.field_1075)).method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Sell-Avg: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(StonksUtils.INTEGER_NUMBERS.format(sellAvgPrice) + " Coins")).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(sellAvgPrice)).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"\n\n")).method_10852((class_2561)class_2561.method_43470((String)"*Standard Deviation: ").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(standardDeviationSell)).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43470((String)"(This measures price volatility. Higher values indicate stronger fluctuations)").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)"\n\n")).method_10852((class_2561)class_2561.method_43470((String)"* Not a true representation of all orders").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}))))));
            long sellVolume = product.quickStatus().sellVolume();
            long sellOrders = product.quickStatus().sellOrders();
            long sellMovingWeek = product.quickStatus().sellMovingWeek();
            source.sendFeedback((class_2561)class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(sellVolume)).method_27692(class_124.field_1063).method_27693(" in " + StonksUtils.SHORT_FLOAT_NUMBERS.format(sellOrders) + " orders").method_10852((class_2561)class_2561.method_43470((String)" | ").method_27692(class_124.field_1080)).method_27693(StonksUtils.SHORT_FLOAT_NUMBERS.format(sellMovingWeek)).method_27692(class_124.field_1063).method_10852((class_2561)class_2561.method_43470((String)" insta-sells in 7d").method_27692(class_124.field_1063)));
            if (ConfigManager.getConfig().general.stonks.showAllDataInStonksCommand) {
                source.sendFeedback((class_2561)class_2561.method_43473());
                double spreadPercentage = BazaarItemAnalytics.spreadPercentage(product);
                double orderImbalancePercentage = BazaarItemAnalytics.orderImbalancePercentage(product);
                source.sendFeedback((class_2561)class_2561.method_43470((String)"Spreed: ").method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)(StonksUtils.FLOAT_NUMBERS.format(spreadPercentage) + " %")).method_54663(Colors.RED.asInt())).method_10852((class_2561)class_2561.method_43470((String)" | ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"Imbalance: ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)(StonksUtils.FLOAT_NUMBERS.format(orderImbalancePercentage) + " %")).method_54663(Colors.PURPLE.asInt())));
            }
            source.sendFeedback((class_2561)class_2561.method_43470((String)SEPARATOR).method_27692(class_124.field_1061));
        }
        return result;
    }
}

