/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.ui;

import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.event.CustomScreenEvents;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.manager.container.ContainerMatcherTrait;
import fr.siroz.cariboustonks.manager.container.overlay.ContainerOverlay;
import fr.siroz.cariboustonks.manager.container.tooltip.ContainerTooltipAppender;
import fr.siroz.cariboustonks.util.Client;
import fr.siroz.cariboustonks.util.ItemUtils;
import fr.siroz.cariboustonks.util.StonksUtils;
import fr.siroz.cariboustonks.util.cooldown.Cooldown;
import fr.siroz.cariboustonks.util.render.gui.ColorHighlight;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbiphoneFavoriteContactFeature
extends Feature
implements ContainerMatcherTrait,
ContainerOverlay,
ContainerTooltipAppender {
    private static final Pattern TITLE_PATTERN = Pattern.compile("^Abiphone.*");
    private static final Cooldown COOLDOWN = Cooldown.of(1L, TimeUnit.SECONDS);
    private final int priority;
    private boolean updated = false;

    public AbiphoneFavoriteContactFeature(int priority) {
        this.priority = priority;
        CustomScreenEvents.KEY_PRESSED.register(this::onKeyPressed);
        CustomScreenEvents.CLOSE.register(this::onClose);
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock();
    }

    @Override
    @Nullable
    public Pattern getTitlePattern() {
        return TITLE_PATTERN;
    }

    @Override
    @NotNull
    public List<ColorHighlight> content(@NotNull Int2ObjectMap<class_1799> slots) {
        ArrayList<ColorHighlight> highlights = new ArrayList<ColorHighlight>();
        for (Int2ObjectMap.Entry entry : slots.int2ObjectEntrySet()) {
            String name;
            class_1799 itemStack = (class_1799)entry.getValue();
            if (itemStack == null || itemStack.method_31574(class_1802.field_8157) || !this.isContact(itemStack) || !ConfigManager.getConfig().uiAndVisuals.favoriteAbiphoneContacts.contains((Object)(name = StonksUtils.stripColor(itemStack.method_7964().getString())))) continue;
            highlights.add(ColorHighlight.yellow(entry.getIntKey(), 0.25f));
        }
        return highlights;
    }

    @Override
    public void appendToTooltip(@Nullable class_1735 focusedSlot, @NotNull class_1799 item, @NotNull List<class_2561> lines) {
        if (this.isContact(item)) {
            String name = StonksUtils.stripColor(item.method_7964().getString());
            if (ConfigManager.getConfig().uiAndVisuals.favoriteAbiphoneContacts.contains((Object)name)) {
                lines.add((class_2561)class_2561.method_43470((String)"SHIFT").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}).method_10852((class_2561)class_2561.method_43470((String)" To remove from favourite contacts").method_27692(class_124.field_1054)));
            } else {
                lines.add((class_2561)class_2561.method_43470((String)"SHIFT").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}).method_10852((class_2561)class_2561.method_43470((String)" To add to favourite contacts").method_27692(class_124.field_1054)));
            }
            lines.add((class_2561)class_2561.method_43470((String)"(from CaribouStonks)").method_27692(class_124.field_1063));
        }
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    private void onKeyPressed(class_437 screen, int keyCode, int scanCode, @NotNull class_1735 slot) {
        if (!this.isEnabled() || screen == null) {
            return;
        }
        if (!this.matches(screen)) {
            return;
        }
        if (class_437.method_25442() && COOLDOWN.test()) {
            class_1799 itemStack = slot.method_7677();
            if (itemStack == null) {
                return;
            }
            if (this.isContact(itemStack)) {
                String name = StonksUtils.stripColor(itemStack.method_7964().getString());
                this.toggleFavouriteContact(itemStack.method_7964(), name);
            }
        }
    }

    private void onClose(class_437 screen) {
        if (this.matches(screen) && this.updated) {
            this.updated = false;
            ConfigManager.saveConfig();
        }
    }

    private boolean isContact(class_1799 itemStack) {
        return ItemUtils.getLore(itemStack).stream().map(class_2561::getString).anyMatch(s -> s.equals("Left-click to call!") || s.equals("Click to call!"));
    }

    private void toggleFavouriteContact(class_2561 rawContactName, String contactName) {
        this.updated = true;
        if (ConfigManager.getConfig().uiAndVisuals.favoriteAbiphoneContacts.contains((Object)contactName)) {
            ConfigManager.getConfig().uiAndVisuals.favoriteAbiphoneContacts.remove((Object)contactName);
            Client.sendMessageWithPrefix((class_2561)class_2561.method_43470((String)"Removed ").method_27692(class_124.field_1061).method_10852(rawContactName).method_27693(" from favourite contacts.").method_27692(class_124.field_1061));
            Client.playSound(class_3417.field_15008, 1.0f, 1.0f);
        } else {
            ConfigManager.getConfig().uiAndVisuals.favoriteAbiphoneContacts.add((Object)contactName);
            Client.sendMessageWithPrefix((class_2561)class_2561.method_43470((String)"Added ").method_27692(class_124.field_1060).method_10852(rawContactName).method_27693(" to favourite contacts.").method_27692(class_124.field_1060));
            Client.playSound(class_3417.field_14815, 1.0f, 1.0f);
        }
    }
}

