/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.ui;

import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.event.MouseEvents;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.manager.keybinds.KeyBind;
import fr.siroz.cariboustonks.manager.keybinds.KeyBindRegistration;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ZoomFeature
extends Feature
implements KeyBindRegistration {
    private static final double ZOOM_MULTIPLIER = 0.3;
    private static final double ZOOM_STEP = 0.05;
    private static final double MIN_ZOOM = 0.05;
    private static final double MAX_ZOOM = 1.0;
    private final KeyBind zoomKeyBind = new KeyBind("Zoom", 67, true);
    private double currentZoomMultiplier = 0.3;

    public ZoomFeature() {
        MouseEvents.MOUSE_SCROLL.register(this::onMouseScroll);
    }

    @Override
    public boolean isEnabled() {
        return ConfigManager.getConfig().uiAndVisuals.zoom.enabled;
    }

    @Override
    @NotNull
    public List<KeyBind> registerKeyBinds() {
        return List.of(this.zoomKeyBind);
    }

    public boolean isZooming() {
        if (!this.isEnabled()) {
            return false;
        }
        return this.zoomKeyBind.isPressed();
    }

    public double getCurrentZoomMultiplier() {
        return this.currentZoomMultiplier;
    }

    public void resetZoomMultiplier() {
        this.currentZoomMultiplier = 0.3;
    }

    private boolean onMouseScroll(double horizontal, double vertical) {
        if (!this.isZooming()) {
            return false;
        }
        if (!ConfigManager.getConfig().uiAndVisuals.zoom.mouseScrolling) {
            return false;
        }
        if (vertical > 0.0) {
            this.decreaseZoom();
        } else if (vertical < 0.0) {
            this.increaseZoom();
        }
        return true;
    }

    private void decreaseZoom() {
        this.currentZoomMultiplier = Math.max(0.05, this.currentZoomMultiplier - 0.05);
    }

    private void increaseZoom() {
        this.currentZoomMultiplier = Math.min(1.0, this.currentZoomMultiplier + 0.05);
    }
}

