/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.manager.waypoint;

import fr.siroz.cariboustonks.manager.waypoint.Waypoint;
import fr.siroz.cariboustonks.manager.waypoint.options.IconOption;
import fr.siroz.cariboustonks.manager.waypoint.options.TextOption;
import fr.siroz.cariboustonks.util.render.WorldRenderUtils;
import fr.siroz.cariboustonks.util.render.WorldRendererProvider;
import java.util.Objects;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;

public final class WaypointRenderer
implements WorldRendererProvider {
    private final Waypoint waypoint;

    WaypointRenderer(Waypoint waypoint) {
        this.waypoint = waypoint;
    }

    @Override
    public void render(WorldRenderContext context) {
        TextOption textOption;
        if (!this.waypoint.isEnabled()) {
            return;
        }
        class_2338 pos = this.waypoint.getPosition().toBlockPos();
        switch (this.waypoint.getType()) {
            case BEAM: {
                WorldRenderUtils.renderBeaconBeam(context, pos, this.waypoint.getColor());
                break;
            }
            case WAYPOINT: {
                WorldRenderUtils.renderFilledWithBeaconBeam(context, pos, this.waypoint.getColor(), this.waypoint.getAlpha(), this.waypoint.isBoxThroughBlocks());
                break;
            }
            case OUTLINED_WAYPOINT: {
                WorldRenderUtils.renderFilledWithBeaconBeam(context, pos, this.waypoint.getColor(), this.waypoint.getAlpha(), this.waypoint.isBoxThroughBlocks());
                WorldRenderUtils.renderOutline(context, this.waypoint.getBox(), this.waypoint.getColor(), this.waypoint.getBoxLineWidth(), this.waypoint.isBoxThroughBlocks());
                break;
            }
            case HIGHLIGHT: {
                WorldRenderUtils.renderFilled(context, pos, this.waypoint.getColor(), this.waypoint.getAlpha(), this.waypoint.isBoxThroughBlocks());
                break;
            }
            case OUTLINED_HIGHLIGHT: {
                WorldRenderUtils.renderFilled(context, pos, this.waypoint.getColor(), this.waypoint.getAlpha(), this.waypoint.isBoxThroughBlocks());
                WorldRenderUtils.renderOutline(context, this.waypoint.getBox(), this.waypoint.getColor(), this.waypoint.getBoxLineWidth(), this.waypoint.isBoxThroughBlocks());
                break;
            }
            case OUTLINE: {
                WorldRenderUtils.renderOutline(context, this.waypoint.getBox(), this.waypoint.getColor(), this.waypoint.getBoxLineWidth(), this.waypoint.isBoxThroughBlocks());
                break;
            }
        }
        class_243 centerPos = pos.method_46558();
        double distance = -1.0;
        IconOption iconOption = this.waypoint.getIconOption();
        if (iconOption.getIcon().isPresent()) {
            float width = iconOption.getWidth();
            float height = iconOption.getHeight();
            if (iconOption.isScaleWithDistance()) {
                float scaleIcon;
                distance = context.camera().method_19326().method_1022(centerPos);
                width = scaleIcon = Math.max((float)distance / 10.0f, 1.0f);
                height = scaleIcon;
            }
            WorldRenderUtils.renderTexture(context, centerPos, width, height, iconOption.getTextureWidth(), iconOption.getTextureHeight(), iconOption.getRenderOffset(), iconOption.getIcon().get(), iconOption.getColor(), iconOption.getAlpha(), iconOption.isThroughBlocks());
        }
        if ((textOption = this.waypoint.getTextOption()).getText().isEmpty() && !textOption.isWithDistance()) {
            return;
        }
        if (textOption.getOffsetY() != -1) {
            centerPos = centerPos.method_1031(0.0, (double)textOption.getOffsetY(), 0.0);
        }
        if (textOption.isWithDistance()) {
            if (distance == -1.0) {
                distance = context.camera().method_19326().method_1022(centerPos);
            }
            class_5250 class_52502 = class_2561.method_43470((String)(Math.round(distance) + "m")).method_27692(class_124.field_1075);
            class_243 class_2432 = centerPos.method_1031(0.0, 1.0, 0.0);
            float f = Math.max((float)distance / 10.0f, 1.0f);
            Objects.requireNonNull(class_310.method_1551().field_1772);
            WorldRenderUtils.renderText(context, (class_2561)class_52502, class_2432, f, 9.0f + 1.0f, textOption.isThroughBlocks());
        }
        if (textOption.getText().isPresent()) {
            if (distance == -1.0) {
                distance = context.camera().method_19326().method_1022(centerPos);
            }
            class_243 class_2433 = centerPos.method_1031(0.0, 1.0, 0.0);
            float f = Math.max((float)distance / 10.0f, 1.0f);
            Objects.requireNonNull(class_310.method_1551().field_1772);
            WorldRenderUtils.renderText(context, textOption.getText().get(), class_2433, f, 9.0f - 12.0f, textOption.isThroughBlocks());
        }
    }
}

