/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.screen.keyshortcut;

import fr.siroz.cariboustonks.feature.keyshortcut.KeyShortcut;
import fr.siroz.cariboustonks.screen.keyshortcut.KeyShortcutScreen;
import fr.siroz.cariboustonks.util.colors.Colors;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class KeyShortcutListWidget
extends class_4265<KeyShortcutEntry> {
    private final KeyShortcutScreen parent;

    KeyShortcutListWidget(class_310 client, @NotNull KeyShortcutScreen parent, int width, int height, int y, int itemHeight) {
        super(client, width, height, y, itemHeight);
        this.parent = parent;
        for (KeyShortcut shortcut : parent.shortcuts.values()) {
            this.method_25321((class_350.class_351)new KeyShortcutEntry(shortcut));
        }
    }

    public int method_25322() {
        return 270;
    }

    protected boolean removeEntry(KeyShortcutEntry entry) {
        if (entry != null && entry.keyShortcut != null) {
            this.parent.shortcuts.remove(entry.keyShortcut.command());
        }
        return super.method_25330((class_350.class_351)entry);
    }

    public void setSelected(@Nullable KeyShortcutEntry entry) {
        super.method_25313((class_350.class_351)entry);
        this.parent.updateButtons();
    }

    void createKeyShortcut() {
        KeyShortcut keyShortcut = new KeyShortcut("", -1);
        boolean hasShortcut = this.parent.shortcuts.containsKey(keyShortcut.command());
        boolean hasEntry = this.method_25396().stream().anyMatch(entry -> entry.keyShortcut.command().equals(keyShortcut.command()));
        if (!hasShortcut && !hasEntry) {
            this.method_25321((class_350.class_351)new KeyShortcutEntry(keyShortcut));
        }
    }

    protected class KeyShortcutEntry
    extends class_4265.class_4266<KeyShortcutEntry> {
        protected KeyShortcut keyShortcut;
        private final List<class_339> children;
        private final class_342 commandWidget;
        private final class_4185 keyBindWidget;
        private boolean waitingForKey = false;

        public KeyShortcutEntry(KeyShortcut keyShortcut) {
            this.keyShortcut = keyShortcut;
            this.commandWidget = new class_342(((KeyShortcutListWidget)KeyShortcutListWidget.this).field_22740.field_1772, KeyShortcutListWidget.this.field_22758 / 2 - 160, 5, 150, 20, (class_2561)class_2561.method_43470((String)"Command"));
            this.commandWidget.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Example: 'equipment' or '/equipment'")));
            this.commandWidget.method_1852(keyShortcut.command());
            this.commandWidget.method_1880(48);
            this.keyBindWidget = class_4185.method_46430((class_2561)class_2561.method_43470((String)("" + keyShortcut.keyCode())), b -> {
                KeyShortcutListWidget.this.parent.setCurrentEntry(this);
                this.waitingForKey = true;
            }).method_46434(0, 0, 56, 20).method_46431();
            this.children = List.of(this.commandWidget, this.keyBindWidget);
        }

        public void setKeyCode(int code) {
            KeyShortcut shortcut = new KeyShortcut(this.commandWidget.method_1882(), code);
            KeyShortcutListWidget.this.parent.shortcuts.put(shortcut.command(), shortcut);
            this.waitingForKey = false;
        }

        public List<? extends class_6379> method_37025() {
            return this.children;
        }

        public List<? extends class_364> method_25396() {
            return this.children;
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickProgress) {
            String label;
            if (KeyShortcutListWidget.this.method_25334() != null && KeyShortcutListWidget.this.method_25334() == this) {
                int x1 = KeyShortcutListWidget.this.method_46426() + (KeyShortcutListWidget.this.field_22758 - entryWidth) / 2;
                int x2 = KeyShortcutListWidget.this.method_46426() + (KeyShortcutListWidget.this.field_22758 + entryWidth) / 2;
                context.method_25294(x1, y - 6, x2, y + entryHeight - 4, Colors.GRAY.asInt());
                context.method_25294(x1 + 1, y - 5, x2 - 1, y + entryHeight - 5, Colors.BLACK.asInt());
            }
            this.commandWidget.method_48229(x + 10, y + 1);
            this.keyBindWidget.method_48229(KeyShortcutListWidget.this.field_22758 / 2 + 44, y);
            this.keyBindWidget.field_22763 = !this.waitingForKey;
            int keyCode = KeyShortcutListWidget.this.parent.shortcuts.values().stream().filter(shortcut -> shortcut.command().equals(this.commandWidget.method_1882())).map(KeyShortcut::keyCode).findFirst().orElse(-1);
            if (this.waitingForKey) {
                label = "..";
            } else if (keyCode == -1) {
                label = "?";
            } else if (keyCode <= -2000) {
                int mouseButton = -2000 - keyCode;
                label = class_3675.class_307.field_1672.method_1447(mouseButton).method_27445().getString();
            } else {
                label = class_3675.method_15985((int)keyCode, (int)0).method_27445().getString();
            }
            boolean duplicate = keyCode != -1 && KeyShortcutListWidget.this.parent.shortcuts.values().stream().map(KeyShortcut::keyCode).filter(c -> c == keyCode).count() > 1L;
            class_5250 message = duplicate ? class_2561.method_43470((String)label).method_27692(class_124.field_1061) : class_2561.method_43470((String)label);
            this.keyBindWidget.method_25355((class_2561)message);
            for (class_339 child : this.children) {
                child.method_25394(context, mouseX, mouseY, tickProgress);
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.keyBindWidget.method_25402(mouseX, mouseY, button)) {
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }
    }
}

