/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.screen.waypoints;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.core.skyblock.IslandType;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.feature.waypoints.WaypointFeature;
import fr.siroz.cariboustonks.manager.waypoint.Waypoint;
import fr.siroz.cariboustonks.screen.CaribousStonksScreen;
import fr.siroz.cariboustonks.screen.waypoints.WaypointsListWidget;
import fr.siroz.cariboustonks.util.colors.Colors;
import fr.siroz.cariboustonks.util.render.gui.DropdownWidget;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7843;
import net.minecraft.class_7845;
import net.minecraft.class_8021;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WaypointScreen
extends CaribousStonksScreen {
    @Nullable
    private final class_437 parent;
    private final WaypointFeature waypointFeature;
    protected IslandType currentIslandType;
    protected final Map<IslandType, List<Waypoint>> waypoints;
    private WaypointsListWidget waypointsListWidget;
    private DropdownWidget<IslandType> islandDropdownWidget;

    private WaypointScreen(@Nullable class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Waypoints").method_27692(class_124.field_1067));
        this.parent = parent;
        this.currentIslandType = SkyBlockAPI.getIsland();
        this.waypointFeature = CaribouStonks.features().getFeature(WaypointFeature.class);
        this.waypoints = this.waypointFeature.getWaypoints();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static WaypointScreen create(@Nullable class_437 parent) {
        return new WaypointScreen(parent);
    }

    @Override
    protected void onInit() {
        this.waypointsListWidget = (WaypointsListWidget)this.method_37063((class_364)new WaypointsListWidget(this.field_22787, this, this.field_22789, this.field_22790 - 120, 32, 24));
        this.islandDropdownWidget = (DropdownWidget)this.method_37063((class_364)new DropdownWidget<IslandType>(this.field_22789 - 160, 8, 150, this.field_22790 - 8, Arrays.asList(IslandType.VALUES), this::onIslandChanged, this.currentIslandType));
        class_7845 grid = new class_7845();
        grid.method_46458().method_46477(5).method_46479(2);
        class_7845.class_7939 adder = grid.method_47610(2);
        adder.method_47612((class_8021)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Add (At Crosshair)"), button -> this.waypointsListWidget.createWaypoint(true)).method_46431());
        adder.method_47612((class_8021)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Add (Your position)"), button -> this.waypointsListWidget.createWaypoint(false)).method_46431());
        adder.method_47613((class_8021)class_4185.method_46430((class_2561)class_5244.field_24334, button -> {
            this.saveWaypoints();
            this.onClose();
        }).method_46432(310).method_46431(), 2);
        grid.method_48222();
        class_7843.method_46442((class_8021)grid, (int)0, (int)(this.field_22790 - 64), (int)this.field_22789, (int)64);
        grid.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.updateButtons();
    }

    @Override
    public void onRender(class_332 context, int mouseX, int mouseY, float delta) {
        super.onRender(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 16, Colors.WHITE.asInt());
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        if (this.islandDropdownWidget.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        boolean mouseClicked = super.onMouseClicked(mouseX, mouseY, button);
        this.updateButtons();
        return mouseClicked;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.islandDropdownWidget.method_25405(mouseX, mouseY) && this.islandDropdownWidget.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    private void saveWaypoints() {
        this.waypointFeature.updateWaypoints(this.waypoints);
        this.waypointFeature.saveWaypoints(this.field_22787);
    }

    private void onIslandChanged(IslandType islandType) {
        this.currentIslandType = islandType;
        this.waypointsListWidget.setNewIslandType(islandType);
    }

    private void updateButtons() {
        this.waypointsListWidget.updateButtons();
    }

    @Override
    public void onClose() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.parent);
    }
}

