/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.screen.waypoints;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.core.skyblock.IslandType;
import fr.siroz.cariboustonks.manager.waypoint.Waypoint;
import fr.siroz.cariboustonks.screen.waypoints.WaypointScreen;
import fr.siroz.cariboustonks.util.Client;
import fr.siroz.cariboustonks.util.colors.Color;
import fr.siroz.cariboustonks.util.colors.Colors;
import fr.siroz.cariboustonks.util.position.Position;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_4286;
import net.minecraft.class_5250;
import net.minecraft.class_5676;
import net.minecraft.class_6379;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

class WaypointsListWidget
extends class_4265<WaypointEntry> {
    private final WaypointScreen waypointScreen;
    private List<Waypoint> waypoints;

    WaypointsListWidget(class_310 client, @NotNull WaypointScreen screen, int width, int height, int y, int itemHeight) {
        super(client, width, height, y, itemHeight);
        this.waypointScreen = screen;
        this.setNewIslandType(screen.currentIslandType);
    }

    public int method_25322() {
        return super.method_25322() + 100;
    }

    protected int method_65507() {
        return super.method_65507();
    }

    void createWaypoint(boolean crosshair) {
        int entryIndex;
        Position position = Position.of(Client.getCurrentPosition(crosshair));
        Waypoint waypoint = Waypoint.builder(position).build();
        WaypointEntry waypointEntry = new WaypointEntry(waypoint);
        class_350.class_351 class_3512 = this.method_25334();
        if (class_3512 instanceof WaypointEntry) {
            WaypointEntry selectedWaypointEntry = (WaypointEntry)class_3512;
            entryIndex = this.method_25396().indexOf((Object)selectedWaypointEntry) + 1;
        } else {
            for (entryIndex = this.method_25396().indexOf((Object)waypointEntry) + 1; entryIndex < this.method_25396().size(); ++entryIndex) {
            }
        }
        this.waypoints.add(waypointEntry.waypoint);
        this.method_25396().add(entryIndex, waypointEntry);
    }

    void setNewIslandType(IslandType newIslandType) {
        this.waypoints = this.waypointScreen.waypoints.get((Object)newIslandType);
        this.updateEntries();
    }

    void updateButtons() {
        for (class_350.class_351 entry : this.method_25396()) {
            if (!(entry instanceof WaypointEntry)) continue;
            WaypointEntry waypointEntry = (WaypointEntry)entry;
            if (waypointEntry.enabledWidget.method_20372() == waypointEntry.waypoint.isEnabled()) continue;
            waypointEntry.enabledWidget.method_25306();
        }
    }

    private void updateEntries() {
        this.method_25339();
        if (this.waypoints == null) {
            return;
        }
        for (Waypoint waypoint : this.waypoints) {
            this.method_25321((class_350.class_351)new WaypointEntry(waypoint));
        }
    }

    private static class_2561 getWaypointTypeList(@NotNull Waypoint.Type current) {
        class_5250 result = class_2561.method_43473();
        for (Waypoint.Type type : Waypoint.Type.values()) {
            String prefix = type == current ? "-> " : "";
            String name = type.name();
            class_5250 line = class_2561.method_43470((String)prefix).method_10852((class_2561)class_2561.method_43470((String)name).method_27692(class_124.field_1073));
            result = !result.getString().isEmpty() ? result.method_27661().method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)line) : line;
        }
        return result;
    }

    protected class WaypointEntry
    extends class_4265.class_4266<WaypointEntry> {
        private Waypoint waypoint;
        private final List<class_339> children;
        private final class_4286 enabledWidget;
        private final class_342 nameWidget;
        private final class_342 xWidget;
        private final class_342 yWidget;
        private final class_342 zWidget;
        private final class_5676<WaypointColors> colorWidget;
        private final class_5676<Waypoint.Type> typeWidget;
        private final class_4185 deleteWidget;

        public WaypointEntry(Waypoint waypoint) {
            this.waypoint = waypoint;
            this.enabledWidget = class_4286.method_54787((class_2561)class_2561.method_43470((String)""), (class_327)((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772).method_54794(waypoint.isEnabled()).method_54793(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Click to toggle the waypoint's visibility"))).method_54791((checkbox, checked) -> waypoint.setEnabled(checked)).method_54788();
            this.nameWidget = new class_342(((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772, 65, 20, (class_2561)class_2561.method_43470((String)"Name"));
            this.nameWidget.method_1852(waypoint.getTextOption().getText().orElse((class_2561)class_2561.method_43470((String)"")).getString());
            this.nameWidget.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Click to edit the waypoint's name.")));
            this.nameWidget.method_1863(this::updateName);
            this.xWidget = new class_342(((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772, 32, 20, (class_2561)class_2561.method_43470((String)"X"));
            this.xWidget.method_1852(Integer.toString(waypoint.getPosition().x()));
            this.xWidget.method_1890(this::testInt);
            this.xWidget.method_1863(this::updateX);
            this.yWidget = new class_342(((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772, 32, 20, (class_2561)class_2561.method_43470((String)"Y"));
            this.yWidget.method_1852(Integer.toString(waypoint.getPosition().y()));
            this.yWidget.method_1890(this::testInt);
            this.yWidget.method_1863(this::updateY);
            this.zWidget = new class_342(((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772, 32, 20, (class_2561)class_2561.method_43470((String)"Z"));
            this.zWidget.method_1852(Integer.toString(waypoint.getPosition().z()));
            this.zWidget.method_1890(this::testInt);
            this.zWidget.method_1863(this::updateZ);
            this.colorWidget = class_5676.method_32606(value -> class_2561.method_43470((String)value.name()).method_54663(value.color.asInt())).method_32624((Object[])WaypointColors.values()).method_32619((Object)WaypointColors.getFromWaypoint(waypoint.getColor())).method_32616().method_32618(value -> class_7919.method_47407((class_2561)WaypointColors.getColoredList(value))).method_32617(0, 0, 56, 20, (class_2561)class_2561.method_43473(), (button, value) -> this.updateColor(value.color));
            this.typeWidget = class_5676.method_32606(value -> class_2561.method_43470((String)value.name())).method_32624((Object[])Waypoint.Type.values()).method_32619((Object)waypoint.getType()).method_32616().method_32618(value -> class_7919.method_47407((class_2561)WaypointsListWidget.getWaypointTypeList(value))).method_32617(0, 0, 56, 20, (class_2561)class_2561.method_43473(), (button, value) -> this.updateType((Waypoint.Type)((Object)value)));
            this.deleteWidget = class_4185.method_46430((class_2561)class_2561.method_43471((String)"selectServer.deleteButton"), button -> {
                WaypointsListWidget.this.waypoints.remove(waypoint);
                WaypointsListWidget.this.method_25396().remove((Object)this);
            }).method_46432(38).method_46431();
            this.children = List.of(this.enabledWidget, this.nameWidget, this.xWidget, this.yWidget, this.zWidget, this.colorWidget, this.typeWidget, this.deleteWidget);
        }

        public List<? extends class_6379> method_37025() {
            return this.children;
        }

        public List<? extends class_364> method_25396() {
            return this.children;
        }

        public void method_25343(@NotNull class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickProgress) {
            context.method_25303(((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772, "X:", WaypointsListWidget.this.field_22758 / 2 - 56, y + 6, Colors.WHITE.asInt());
            context.method_25303(((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772, "Y:", WaypointsListWidget.this.field_22758 / 2 - 11, y + 6, Colors.WHITE.asInt());
            context.method_25303(((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772, "Z:", WaypointsListWidget.this.field_22758 / 2 + 35, y + 6, Colors.WHITE.asInt());
            this.enabledWidget.method_48229(x + 10, y + 1);
            this.nameWidget.method_48229(x + 32, y);
            this.xWidget.method_48229(WaypointsListWidget.this.field_22758 / 2 - 46, y);
            this.yWidget.method_48229(WaypointsListWidget.this.field_22758 / 2 - 1, y);
            this.zWidget.method_48229(WaypointsListWidget.this.field_22758 / 2 + 44, y);
            this.colorWidget.method_48229(x + entryWidth - 79, y);
            this.typeWidget.method_48229(x + entryWidth - 18, y);
            this.deleteWidget.method_48229(x + entryWidth + 43, y);
            for (class_339 child : this.children) {
                child.method_25394(context, mouseX, mouseY, tickProgress);
            }
        }

        private void updateName(String name) {
            this.waypoint.getTextOption().updateText((class_2561)class_2561.method_43470((String)name));
        }

        private void updateX(String xString) {
            this.updateInt(xString, this.waypoint.getPosition().x(), (Int2ObjectFunction<Waypoint>)((Int2ObjectFunction)x -> {
                this.waypoint.updatePosition(Position.of(x, this.waypoint.getPosition().y(), this.waypoint.getPosition().z()));
                return this.waypoint;
            }));
        }

        private void updateY(String yString) {
            this.updateInt(yString, this.waypoint.getPosition().y(), (Int2ObjectFunction<Waypoint>)((Int2ObjectFunction)y -> {
                this.waypoint.updatePosition(Position.of(this.waypoint.getPosition().x(), y, this.waypoint.getPosition().z()));
                return this.waypoint;
            }));
        }

        private void updateZ(String zString) {
            this.updateInt(zString, this.waypoint.getPosition().z(), (Int2ObjectFunction<Waypoint>)((Int2ObjectFunction)z -> {
                this.waypoint.updatePosition(Position.of(this.waypoint.getPosition().x(), this.waypoint.getPosition().y(), z));
                return this.waypoint;
            }));
        }

        private void updateInt(String newValueStr, int currentValue, Int2ObjectFunction<Waypoint> editedWaypoint) {
            try {
                int newValue = this.parseInt(newValueStr);
                if (newValue == currentValue) {
                    return;
                }
                this.waypoint = (Waypoint)editedWaypoint.apply(newValue);
                int index = WaypointsListWidget.this.waypoints.indexOf(this.waypoint);
                if (index >= 0) {
                    WaypointsListWidget.this.waypoints.set(index, this.waypoint);
                }
            }
            catch (NumberFormatException ex) {
                CaribouStonks.LOGGER.warn("[Waypoints] Failed to parse integer: {}", (Object)newValueStr, (Object)ex);
            }
        }

        private boolean testInt(String string) {
            try {
                this.parseInt(string);
                return true;
            }
            catch (NumberFormatException ignored) {
                return false;
            }
        }

        private void updateColor(Color color) {
            if (this.waypoint.getColor().equals(color)) {
                return;
            }
            this.waypoint.updateColor(color);
            int index = WaypointsListWidget.this.waypoints.indexOf(this.waypoint);
            if (index >= 0) {
                WaypointsListWidget.this.waypoints.set(index, this.waypoint);
            }
        }

        private void updateType(Waypoint.Type type) {
            if (this.waypoint.getType() == type) {
                return;
            }
            this.waypoint.updateType(type);
            int index = WaypointsListWidget.this.waypoints.indexOf(this.waypoint);
            if (index >= 0) {
                WaypointsListWidget.this.waypoints.set(index, this.waypoint);
            }
        }

        private int parseInt(@NotNull String value) throws NumberFormatException {
            return value.isEmpty() || value.equals("-") ? 0 : Integer.parseInt(value);
        }
    }

    private static enum WaypointColors {
        RED(Color.fromHexString("#FF5555")),
        LIGHT_PURPLE(Color.fromHexString("#FF55FF")),
        YELLOW(Color.fromHexString("#FFFF55")),
        WHITE(Color.fromHexString("#FFFFFF")),
        BLACK(Color.fromHexString("#000000")),
        DARK_BLUE(Color.fromHexString("#0000AA")),
        DARK_GREEN(Color.fromHexString("#00AA00")),
        DARK_AQUA(Color.fromHexString("#00AAAA")),
        DARK_RED(Color.fromHexString("#AA0000")),
        DARK_PURPLE(Color.fromHexString("#AA00AA")),
        GOLD(Color.fromHexString("#FFAA00")),
        GRAY(Color.fromHexString("#AAAAAA")),
        DARK_GRAY(Color.fromHexString("#555555")),
        BLUE(Color.fromHexString("#5555FF")),
        GREEN(Color.fromHexString("#55FF55")),
        AQUA(Color.fromHexString("#55FFFF"));

        final Color color;

        private WaypointColors(Color color) {
            this.color = color;
        }

        public static class_2561 getColoredList(@NotNull WaypointColors current) {
            class_5250 result = class_2561.method_43473();
            for (WaypointColors c : WaypointColors.values()) {
                String prefix = c == current ? "-> " : "";
                String name = c.name();
                class_5250 line = class_2561.method_43470((String)prefix).method_10852((class_2561)class_2561.method_43470((String)name).method_27694(style -> style.method_36139(c.color.asInt())));
                result = !result.getString().isEmpty() ? result.method_27661().method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)line) : line;
            }
            return result;
        }

        public static WaypointColors getFromWaypoint(@NotNull Color color) {
            return Arrays.stream(WaypointColors.values()).filter(waypointColors -> color.equals(waypointColors.color)).findFirst().orElse(RED);
        }
    }
}

