/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.util;

import com.google.gson.JsonParser;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.core.data.mod.SkyBlockAttribute;
import fr.siroz.cariboustonks.util.Rarity;
import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectReferencePair;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5699;
import net.minecraft.class_7923;
import net.minecraft.class_9274;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9296;
import net.minecraft.class_9322;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemUtils {
    private static final String ITEM_ID = "id";
    private static final String ITEM_UUID = "uuid";
    private static final Pattern ABILITY = Pattern.compile("Ability: (?<name>.*?) *");
    private static final List<ObjectReferencePair<String, Rarity>> LORE_RARITIES = List.of(ObjectReferencePair.of((Object)"ULTIMATE", (Object)((Object)Rarity.ULTIMATE)), ObjectReferencePair.of((Object)"DIVINE", (Object)((Object)Rarity.DIVINE)), ObjectReferencePair.of((Object)"MYTHIC", (Object)((Object)Rarity.MYTHIC)), ObjectReferencePair.of((Object)"SPECIAL", (Object)((Object)Rarity.SPECIAL)), ObjectReferencePair.of((Object)"LEGENDARY", (Object)((Object)Rarity.LEGENDARY)), ObjectReferencePair.of((Object)"EPIC", (Object)((Object)Rarity.EPIC)), ObjectReferencePair.of((Object)"RARE", (Object)((Object)Rarity.RARE)), ObjectReferencePair.of((Object)"UNCOMMON", (Object)((Object)Rarity.UNCOMMON)), ObjectReferencePair.of((Object)"COMMON", (Object)((Object)Rarity.COMMON)));
    private static final Int2ReferenceOpenHashMap<Rarity> CACHE_RARITIES = new Int2ReferenceOpenHashMap();

    private ItemUtils() {
    }

    @NotNull
    public static class_2487 getCustomData(@NotNull class_9322 stack) {
        return ((class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57463();
    }

    @NotNull
    public static String getSkyBlockItemId(@NotNull class_9322 stack) {
        return ItemUtils.getCustomData(stack).method_68564(ITEM_ID, "");
    }

    @NotNull
    public static String getSkyBlockItemUuid(@NotNull class_9322 stack) {
        return ItemUtils.getCustomData(stack).method_68564(ITEM_UUID, "");
    }

    @Deprecated
    @NotNull
    public static Optional<class_1792> getItemByNumericId(int id) {
        return class_7923.field_41178.method_10220().filter(item -> class_7923.field_41178.method_10206(item) == id).findFirst();
    }

    public static Optional<class_1792> getItemById(@NotNull String id) {
        try {
            class_2960 search = class_2960.method_60654((String)id);
            return class_7923.field_41178.method_17966(search);
        }
        catch (Exception ex) {
            CaribouStonks.LOGGER.warn("[ItemUtils] Unable to find {} in Item Registry", (Object)id, (Object)ex);
            return Optional.empty();
        }
    }

    @NotNull
    public static List<class_2561> getLore(@NotNull class_1799 stack) {
        return ((class_9290)stack.method_58695(class_9334.field_49632, (Object)class_9290.field_49340)).comp_2401();
    }

    @Nullable
    public static Matcher getLoreLineIfMatch(@NotNull class_1799 stack, @NotNull Pattern pattern) {
        Matcher matcher = pattern.matcher("");
        for (class_2561 line : ItemUtils.getLore(stack)) {
            if (!matcher.reset(line.getString()).matches()) continue;
            return matcher;
        }
        return null;
    }

    @Nullable
    public static String getLoreLineIf(class_1799 stack, Predicate<String> predicate) {
        for (class_2561 line : ItemUtils.getLore(stack)) {
            String string = line.getString();
            if (!predicate.test(string)) continue;
            return string;
        }
        return null;
    }

    @NotNull
    public static String getConcatenatedLore(@NotNull class_1799 item) {
        return ItemUtils.concatenateLore(ItemUtils.getLore(item));
    }

    @NotNull
    public static String concatenateLore(@NotNull List<class_2561> lore) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < lore.size(); ++i) {
            stringBuilder.append(lore.get(i).getString());
            if (i == lore.size() - 1) continue;
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    @NotNull
    public static String getSkyBlockApiId(@NotNull class_9322 itemStack) {
        class_2487 customData = ItemUtils.getCustomData(itemStack);
        String id = customData.method_68564(ITEM_ID, "");
        if (customData.method_10545("is_shiny")) {
            return "SHINY_" + id;
        }
        switch (id) {
            case "ENCHANTED_BOOK": {
                if (!customData.method_10545("enchantments")) break;
                class_2487 enchants = customData.method_68568("enchantments");
                Optional firstEnchant = enchants.method_10541().stream().findFirst();
                String enchant = firstEnchant.orElse("");
                return "ENCHANTMENT_" + enchant.toUpperCase(Locale.ENGLISH) + "_" + enchants.method_68083(enchant, 0);
            }
            case "POTION": {
                String splash;
                String enhanced = customData.method_10545("enhanced") ? "_ENHANCED" : "";
                String extended = customData.method_10545("extended") ? "_EXTENDED" : "";
                String string = splash = customData.method_10545("splash") ? "_SPLASH" : "";
                if (!customData.method_10545("potion") || !customData.method_10545("potion_level")) break;
                return (customData.method_68564("potion", "") + "_" + id + "_" + customData.method_68083("potion_level", 0) + enhanced + extended + splash).toUpperCase(Locale.ENGLISH);
            }
            case "RUNE": {
                if (!customData.method_10545("runes")) break;
                class_2487 runes = customData.method_68568("runes");
                String rune = runes.method_10541().stream().findFirst().orElse("");
                return rune.toUpperCase(Locale.ENGLISH) + "_RUNE_" + runes.method_68083(rune, 0);
            }
            case "ATTRIBUTE_SHARD": {
                String name = ((class_2561)itemStack.method_58695(class_9334.field_49631, (Object)class_2561.method_43473())).getString();
                SkyBlockAttribute attribute = CaribouStonks.core().getModDataSource().getAttributeByShardName(name);
                if (attribute == null) break;
                return attribute.skyBlockApiId();
            }
        }
        return id;
    }

    @Nullable
    public static Rarity getItemRarity(@Nullable class_1799 stack) {
        int hashCode;
        if (stack == null || stack.method_7960()) {
            return null;
        }
        String itemUuid = ItemUtils.getSkyBlockItemUuid((class_9322)stack);
        int n = hashCode = itemUuid.isEmpty() ? System.identityHashCode(stack) : itemUuid.hashCode();
        if (CACHE_RARITIES.containsKey(hashCode)) {
            return (Rarity)((Object)CACHE_RARITIES.get(hashCode));
        }
        List<class_2561> lore = ItemUtils.getLore(stack);
        String[] tooltipStr = (String[])lore.stream().map(class_2561::getString).toArray(String[]::new);
        for (ObjectReferencePair<String, Rarity> loreToRarity : LORE_RARITIES) {
            Rarity rarity;
            if (!Arrays.stream(tooltipStr).anyMatch(line -> line.contains((CharSequence)loreToRarity.left())) || (rarity = (Rarity)((Object)loreToRarity.right())) == null) continue;
            CACHE_RARITIES.put(hashCode, (Object)rarity);
            return rarity;
        }
        CACHE_RARITIES.put(hashCode, null);
        return null;
    }

    @Nullable
    public static String getAbility(@NotNull class_1799 stack) {
        Matcher abilityMatcher = ItemUtils.getLoreLineIfMatch(stack, ABILITY);
        return abilityMatcher != null ? abilityMatcher.group("name") : null;
    }

    public static List<class_1799> getArmor(@NotNull class_1309 entity) {
        return class_9274.field_49224.method_66665().stream().filter(slot -> slot.method_5925() == class_1304.class_1305.field_6178).map(arg_0 -> ((class_1309)entity).method_6118(arg_0)).toList();
    }

    @NotNull
    public static class_1799 createSkull(@NotNull String textureB64) {
        class_1799 skull = new class_1799((class_1935)class_1802.field_8575);
        try {
            PropertyMap map = new PropertyMap();
            map.put((Object)"textures", (Object)new Property("textures", textureB64));
            class_9296 profile = new class_9296(Optional.of("skull"), Optional.of(UUID.randomUUID()), map);
            skull.method_57379(class_9334.field_49617, (Object)profile);
        }
        catch (Exception exception) {
            CaribouStonks.LOGGER.error("[ItemUtils] Failed to create skull", (Throwable)exception);
        }
        return skull;
    }

    @NotNull
    public static String getHeadTexture(@NotNull class_1799 stack) {
        if (!stack.method_31574(class_1802.field_8575) || !stack.method_57826(class_9334.field_49617)) {
            return "";
        }
        class_9296 profile = (class_9296)stack.method_58694(class_9334.field_49617);
        if (profile == null) {
            return "";
        }
        return profile.comp_2412().get((Object)"textures").stream().map(Property::value).findFirst().orElse("");
    }

    @NotNull
    public static Optional<String> getHeadTextureOptional(@NotNull class_1799 stack) {
        String texture = ItemUtils.getHeadTexture(stack);
        return texture.isBlank() ? Optional.empty() : Optional.of(texture);
    }

    public static Optional<PropertyMap> propertyMapWithTexture(@NotNull String textureValue) {
        try {
            String json = "[{\"name\":\"textures\",\"value\":\"" + textureValue + "\"}]";
            PropertyMap propertyMap = (PropertyMap)class_5699.field_40725.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)json)).getOrThrow();
            return Optional.ofNullable(propertyMap);
        }
        catch (Throwable ex) {
            CaribouStonks.LOGGER.error("[ItemUtils] Failed to get PropertyMap from the texture", ex);
            return Optional.empty();
        }
    }
}

