/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.util;

import fr.siroz.cariboustonks.util.ItemUtils;
import java.util.Locale;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_9322;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class NotEnoughUpdatesUtils {
    private NotEnoughUpdatesUtils() {
    }

    @NotNull
    public static String getNeuId(@Nullable class_1799 stack) {
        if (stack == null) {
            return "";
        }
        String id = ItemUtils.getSkyBlockItemId((class_9322)stack);
        class_2487 customData = ItemUtils.getCustomData((class_9322)stack);
        return switch (id) {
            case "ENCHANTED_BOOK" -> {
                class_2487 enchantments = customData.method_68568("enchantments");
                String enchant = enchantments.method_10541().stream().findFirst().orElse("");
                yield enchant.toUpperCase(Locale.ENGLISH) + ";" + enchantments.method_68083(enchant, 0);
            }
            case "RUNE" -> {
                class_2487 runes = customData.method_68568("runes");
                String rune = runes.method_10541().stream().findFirst().orElse("");
                yield rune.toUpperCase(Locale.ENGLISH) + "_RUNE;" + runes.method_68083(rune, 0);
            }
            case "POTION" -> "POTION_" + customData.method_68564("potion", "").toUpperCase(Locale.ENGLISH) + ";" + customData.method_68083("potion_level", 0);
            case "ATTRIBUTE_SHARD" -> "";
            case "PARTY_HAT_CRAB", "BALLOON_HAT_2024" -> id + "_" + customData.method_68564("party_hat_color", "").toUpperCase(Locale.ENGLISH);
            case "PARTY_HAT_CRAB_ANIMATED" -> "PARTY_HAT_CRAB_" + customData.method_68564("party_hat_color", "").toUpperCase(Locale.ENGLISH) + "_ANIMATED";
            case "PARTY_HAT_SLOTH" -> id + "_" + customData.method_68564("party_hat_emoji", "").toUpperCase(Locale.ENGLISH);
            default -> id.replace(":", "-");
        };
    }

    @NotNull
    public static String getNeuIdFromSkyBlockId(@NotNull String skyBlockItemId) {
        String enchantment;
        int lastUnderscore;
        if (skyBlockItemId.isEmpty()) {
            return "";
        }
        if (skyBlockItemId.startsWith("ENCHANTMENT_") && (lastUnderscore = (enchantment = skyBlockItemId.substring("ENCHANTMENT_".length())).lastIndexOf(95)) != -1 && lastUnderscore < enchantment.length() - 1) {
            String name = enchantment.substring(0, lastUnderscore);
            String level = enchantment.substring(lastUnderscore + 1);
            return name + ";" + level;
        }
        return skyBlockItemId.replace(":", "-");
    }
}

