/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.util;

import com.mojang.brigadier.Command;
import fr.siroz.cariboustonks.core.json.GsonProvider;
import fr.siroz.cariboustonks.core.scheduler.TickScheduler;
import fr.siroz.cariboustonks.util.ScoreboardUtils;
import fr.siroz.cariboustonks.util.TabListUtils;
import fr.siroz.cariboustonks.util.render.WorldRenderUtils;
import fr.siroz.cariboustonks.util.render.animation.AnimationUtils;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_421;
import net.minecraft.class_437;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StonksUtils {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final Pattern COLOR_CODE_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    public static final NumberFormat INTEGER_NUMBERS = NumberFormat.getIntegerInstance(Locale.US);
    public static final NumberFormat DOUBLE_NUMBERS = StonksUtils.make(NumberFormat.getInstance(Locale.US), nf -> nf.setMaximumFractionDigits(2));
    public static final NumberFormat FLOAT_NUMBERS = StonksUtils.make(NumberFormat.getInstance(Locale.US), nf -> nf.setMaximumFractionDigits(1));
    public static final NumberFormat SHORT_INTEGER_NUMBERS = NumberFormat.getCompactNumberInstance(Locale.US, NumberFormat.Style.SHORT);
    public static final NumberFormat SHORT_FLOAT_NUMBERS = StonksUtils.make(NumberFormat.getCompactNumberInstance(Locale.US, NumberFormat.Style.SHORT), nf -> nf.setMinimumFractionDigits(1));

    private StonksUtils() {
    }

    @ApiStatus.Internal
    public static void initUtilities() {
        WorldRenderUtils.initRenderUtilities();
        AnimationUtils.initAnimationUtilities();
        TickScheduler.getInstance().runRepeating(StonksUtils::updateUtilities, 3, TimeUnit.SECONDS);
    }

    private static void updateUtilities() {
        ScoreboardUtils.internalUpdate(CLIENT);
        TabListUtils.internalUpdate(CLIENT);
    }

    public static void showFatalErrorScreen(@NotNull class_2561 title, @NotNull class_2561 message) {
        if (StonksUtils.CLIENT.field_1724 != null) {
            CLIENT.method_1507((class_437)new class_421(title, message));
        }
    }

    @Contract(pure=true)
    @NotNull
    public static String stripColor(@Nullable String input) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        return COLOR_CODE_PATTERN.matcher(input).replaceAll("");
    }

    public static int convertHotbarToSlotIndex(int hotbarIndex) {
        if (hotbarIndex < 0 || hotbarIndex > 8) {
            return -1;
        }
        return 36 + hotbarIndex;
    }

    public static boolean isEdgeSlot(int slotId, int rows) {
        if (slotId < 0 || slotId >= rows * 9) {
            return false;
        }
        int row = slotId / 9;
        int col = slotId % 9;
        return col == 0 || col == 8 || row == 0 || row == rows - 1;
    }

    public static boolean isConnectedToHypixel() {
        String serverAddress = CLIENT.method_1558() != null ? StonksUtils.CLIENT.method_1558().field_3761.toLowerCase() : "";
        String serverBrand = StonksUtils.CLIENT.field_1724 != null && StonksUtils.CLIENT.field_1724.field_3944 != null && StonksUtils.CLIENT.field_1724.field_3944.method_52790() != null ? StonksUtils.CLIENT.field_1724.field_3944.method_52790() : "";
        return serverAddress.contains("hypixel.net") || serverBrand.contains("Hypixel BungeeCord");
    }

    public static Optional<String> textToJson(@NotNull class_2561 text) {
        try {
            String json = GsonProvider.standard().toJson((Object)text);
            return Optional.ofNullable(json);
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    public static Optional<class_2561> jsonToText(@NotNull String json) {
        try {
            class_2561 text = (class_2561)GsonProvider.standard().fromJson(json, class_2561.class);
            return Optional.ofNullable(text);
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    @Contract(value="_, _ -> param1")
    public static <T> T make(@NotNull T object, @NotNull Consumer<? super T> initializer) {
        initializer.accept(object);
        return object;
    }

    public static int toInt(@Nullable String s, int defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Exception ignored) {
            return defaultValue;
        }
    }

    public static double calculateMedian(@NotNull List<Double> values) {
        if (values.isEmpty()) {
            return -1.0;
        }
        List sorted = values.stream().sorted().toList();
        int n = sorted.size();
        if (n % 2 == 1) {
            return (Double)sorted.get(n / 2);
        }
        return ((Double)sorted.get(n / 2 - 1) + (Double)sorted.get(n / 2)) / 2.0;
    }

    public static int levenshteinDistance(@NotNull String s1, @NotNull String s2) {
        int[][] dp = new int[s1.length() + 1][s2.length() + 1];
        for (int i = 0; i <= s1.length(); ++i) {
            for (int j = 0; j <= s2.length(); ++j) {
                dp[i][j] = i == 0 ? j : (j == 0 ? i : (s1.charAt(i - 1) == s2.charAt(j - 1) ? dp[i - 1][j - 1] : 1 + Math.min(dp[i - 1][j - 1], Math.min(dp[i - 1][j], dp[i][j - 1]))));
            }
        }
        return dp[s1.length()][s2.length()];
    }

    @Contract(pure=true)
    @NotNull
    public static Command<FabricClientCommandSource> openScreen(@NotNull Supplier<class_437> screenSupplier) {
        return context -> {
            CLIENT.method_63588(() -> StonksUtils.lambda$openScreen$3((Supplier)screenSupplier));
            return 1;
        };
    }

    @NotNull
    public static <T> List<T> removeEverySecondElement(@NotNull List<T> list) {
        if (list.size() < 3) {
            return list;
        }
        ArrayList<T> result = new ArrayList<T>();
        result.add(list.getFirst());
        for (int i = 1; i < list.size() - 1; ++i) {
            if (i % 2 != 0) continue;
            result.add(list.get(i));
        }
        result.add(list.getLast());
        return result;
    }

    @NotNull
    public static <T> List<T> reduceListToApproxSize(@NotNull List<T> list, int targetSize) {
        if (list.size() <= targetSize) {
            return list;
        }
        ArrayList<T> result = new ArrayList<T>();
        int step = list.size() / targetSize;
        for (int i = 0; i < list.size(); i += step) {
            result.add(list.get(i));
        }
        if (!result.contains(list.getLast())) {
            result.add(list.getLast());
        }
        return result;
    }

    private static /* synthetic */ void lambda$openScreen$3(Supplier screenSupplier) {
        CLIENT.method_1507((class_437)screenSupplier.get());
    }
}

