/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.util.colors;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class Color {
    public static final Color DEFAULT = new Color(-1, -1, -1, -1);
    private static final Pattern HEX_PATTERN = Pattern.compile("#?([0-9a-fA-F]{6})([0-9a-fA-F]{2})?");
    public final int r;
    public final int g;
    public final int b;
    public final int a;

    @Contract(pure=true)
    public Color(@NotNull Color color) {
        this(color.r, color.g, color.b, color.a);
    }

    @Contract(pure=true)
    public Color(@NotNull Color color, int alpha) {
        this(color.r, color.g, color.b, alpha);
    }

    public Color(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public Color(float r, float g, float b) {
        this(r, g, b, 1.0f);
    }

    public Color(int r, int g, int b, int a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public Color(float r, float g, float b, float a) {
        this.r = (int)(r * 255.0f);
        this.g = (int)(g * 255.0f);
        this.b = (int)(b * 255.0f);
        this.a = (int)(a * 255.0f);
    }

    public static Color fromFormatting(@NotNull class_124 formatting) {
        if (formatting.method_532() == null) {
            return DEFAULT;
        }
        return Color.fromInt(formatting.method_532() | 0xFF000000);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Color fromDyeColor(@NotNull class_1767 color) {
        return Color.fromInt(color.method_7787() | 0xFF000000);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static Color fromInt(int num) {
        if ((num & 0xFF000000) == 0) {
            num |= 0xFF000000;
        }
        return new Color(num >> 16 & 0xFF, num >> 8 & 0xFF, num & 0xFF, num >> 24 & 0xFF);
    }

    public static Color fromHexString(@NotNull String hex) {
        Matcher hexMatcher = HEX_PATTERN.matcher(hex.trim());
        if (!hexMatcher.matches()) {
            return DEFAULT;
        }
        if (hexMatcher.group(2) == null) {
            return Color.fromInt(Integer.parseInt(hexMatcher.group(1), 16)).withAlpha(255);
        }
        return Color.fromInt(Integer.parseInt(hexMatcher.group(1), 16)).withAlpha(Integer.parseInt(hexMatcher.group(2), 16));
    }

    public Color withAlpha(int a) {
        return new Color(this, a);
    }

    public Color withAlpha(float a) {
        return new Color(this, (int)(a * 255.0f));
    }

    public int asInt() {
        int a = Math.min(this.a, 255);
        int r = Math.min(this.r, 255);
        int g = Math.min(this.g, 255);
        int b = Math.min(this.b, 255);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public float[] asFloatComponents() {
        return new float[]{(float)this.r / 255.0f, (float)this.g / 255.0f, (float)this.b / 255.0f};
    }

    public String toHexString() {
        return "#" + String.format("%08x", this.r << 24 | this.g << 16 | this.b << 8 | this.a);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Color)) {
            return false;
        }
        Color color = (Color)o;
        return this.r == color.r && this.g == color.g && this.b == color.b && this.a == color.a;
    }

    public String toString() {
        return this.toHexString();
    }
}

