/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.util.cooldown;

import fr.siroz.cariboustonks.util.TimeUtils;
import fr.siroz.cariboustonks.util.cooldown.CooldownImpl;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public interface Cooldown {
    @NotNull
    public static Cooldown of(long amount, @NotNull TimeUnit unit) {
        return new CooldownImpl(amount, unit);
    }

    default public boolean test() {
        if (!this.testSilently()) {
            return false;
        }
        this.reset();
        return true;
    }

    default public boolean testSilently() {
        return this.elapsed() > this.getTimeout();
    }

    default public long elapsed() {
        return TimeUtils.nowMillis() - this.getLastTested().orElse(0L);
    }

    default public void reset() {
        this.setLastTested(TimeUtils.nowMillis());
    }

    @NotNull
    public OptionalLong getLastTested();

    public void setLastTested(long var1);

    public long getTimeout();

    @NotNull
    public Cooldown copy();
}

