/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.util.cooldown;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import fr.siroz.cariboustonks.util.cooldown.Cooldown;
import fr.siroz.cariboustonks.util.cooldown.CooldownMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

final class CooldownMapImpl<T>
implements CooldownMap<T> {
    private final Cooldown base;
    private final LoadingCache<T, Cooldown> cache;

    CooldownMapImpl(final @NotNull Cooldown base) {
        this.base = base;
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(base.getTimeout() + 10000L, TimeUnit.MILLISECONDS).build(new CacheLoader<T, Cooldown>(this){

            @NotNull
            public Cooldown load(@NotNull T key) {
                return base.copy();
            }
        });
    }

    @Override
    @NotNull
    public Cooldown getBase() {
        return this.base;
    }

    @Override
    @NotNull
    public Cooldown get(@NotNull T key) {
        return (Cooldown)this.cache.getUnchecked(key);
    }

    @Override
    public void put(@NotNull T key, @NotNull Cooldown cooldown) {
        this.cache.put(key, (Object)cooldown);
    }

    @Override
    @NotNull
    public Map<T, Cooldown> getAll() {
        return this.cache.asMap();
    }
}

