/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.util.math.bezier;

import fr.siroz.cariboustonks.util.math.bezier.BezierCurve;
import fr.siroz.cariboustonks.util.math.bezier.PolynomialFitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_243;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BezierFitter {
    private final int degree;
    protected final List<class_243> points = new ArrayList<class_243>();
    private final PolynomialFitter[] fitters;
    private BezierCurve lastBezierCurve = null;

    public BezierFitter(int degree) {
        this.degree = degree;
        this.fitters = new PolynomialFitter[]{new PolynomialFitter(degree), new PolynomialFitter(degree), new PolynomialFitter(degree)};
    }

    public void addPoint(@NotNull class_243 point) {
        if (!(Double.isFinite(point.field_1352) && Double.isFinite(point.field_1351) && Double.isFinite(point.field_1350))) {
            throw new IllegalArgumentException();
        }
        double[] array = this.toDoubleArray(point);
        IntStream.range(0, this.fitters.length).forEach(i -> this.fitters[i].addPoint(this.points.size(), array[i]));
        this.points.add(point);
        this.lastBezierCurve = null;
    }

    @Nullable
    public class_243 getLastPoint() {
        return this.points.isEmpty() ? null : this.points.getLast();
    }

    public boolean isEmpty() {
        return this.points.isEmpty();
    }

    @Nullable
    public BezierCurve fit() {
        if (this.points.size() <= this.degree) {
            return null;
        }
        if (this.lastBezierCurve != null) {
            return this.lastBezierCurve;
        }
        List<double[]> coefficients = Arrays.stream(this.fitters).map(PolynomialFitter::fit).toList();
        this.lastBezierCurve = new BezierCurve(coefficients);
        return this.lastBezierCurve;
    }

    public void reset() {
        this.points.clear();
        Arrays.stream(this.fitters).forEach(PolynomialFitter::reset);
        this.lastBezierCurve = null;
    }

    @Contract(value="_ -> new", pure=true)
    private double @NotNull [] toDoubleArray(@NotNull class_243 vec) {
        return new double[]{vec.field_1352, vec.field_1351, vec.field_1350};
    }
}

