/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.util.position;

import fr.siroz.cariboustonks.util.position.Position;
import java.util.Comparator;
import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;

public record ImmutablePosition(int x, int y, int z) implements Position
{
    private static final Comparator<Position> POSITION_COMPARATOR = Comparator.comparing(Position::x, Integer::compareTo).thenComparing(Position::z, Integer::compareTo).thenComparing(Position::y, Integer::compareTo);

    @Override
    public double distanceTo(@NotNull Position other) {
        double dx = other.x() - this.x;
        double dy = other.y() - this.y;
        double dz = other.z() - this.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    @Override
    public double squaredDistanceTo(@NotNull Position other) {
        double dx = other.x() - this.x;
        double dy = other.y() - this.y;
        double dz = other.z() - this.z;
        return dx * dx + dy * dy + dz * dz;
    }

    @Override
    public boolean isInRange(@NotNull Position other, double radius) {
        return this.squaredDistanceTo(other) < radius * radius;
    }

    @Override
    @NotNull
    public Position offset(int dx, int dy, int dz) {
        return new ImmutablePosition(this.x + dx, this.y + dy, this.z + dz);
    }

    @Override
    @NotNull
    public class_2338 toBlockPos() {
        return new class_2338(this.x, this.y, this.z);
    }

    @Override
    @NotNull
    public class_243 toVec3d() {
        return new class_243((double)this.x, (double)this.y, (double)this.z);
    }

    @Override
    @NotNull
    public class_238 toBox() {
        return new class_238(new class_2338(this.x, this.y, this.z));
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutablePosition position = (ImmutablePosition)o;
        return this.x == position.x() && this.y == position.y() && this.z == position.z();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }

    @Override
    public int compareTo(@NotNull Position that) {
        return POSITION_COMPARATOR.compare(this, that);
    }
}

