/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.util.position;

import fr.siroz.cariboustonks.util.position.ImmutablePosition;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface Position
extends Comparable<Position> {
    public static final Position ORIGIN = new ImmutablePosition(0, 0, 0);

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static Position of(int x, int y, int z) {
        return new ImmutablePosition(x, y, z);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Position of(@NotNull Position position) {
        return Position.of(position.x(), position.y(), position.z());
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Position of(@NotNull class_2338 pos) {
        return Position.of(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Position of(@NotNull class_243 vec3d) {
        return Position.of((int)vec3d.method_10216(), (int)vec3d.method_10214(), (int)vec3d.method_10215());
    }

    public int x();

    public int y();

    public int z();

    public double distanceTo(@NotNull Position var1);

    public double squaredDistanceTo(@NotNull Position var1);

    public boolean isInRange(Position var1, double var2);

    @NotNull
    public Position offset(int var1, int var2, int var3);

    @NotNull
    public class_2338 toBlockPos();

    @NotNull
    public class_243 toVec3d();

    @NotNull
    public class_238 toBox();

    @NotNull
    default public String asChatCoordinates() {
        return "x: " + this.x() + ", y: " + this.y() + ", z: " + this.z();
    }

    public boolean equals(Object var1);

    @Override
    public int compareTo(@NotNull Position var1);

    default public String asString() {
        return "x:" + this.x() + ",y:" + this.y() + ",z:" + this.z();
    }

    @NotNull
    public static Position fromString(@NotNull String positionString) {
        String[] parts = positionString.split(",");
        if (parts.length != 3) {
            throw new IllegalArgumentException("Invalid format: expected 'x:<value>,y:<value>,z:<value>' but got '" + positionString + "' instead");
        }
        Map<String, Integer> values = Stream.of(parts).map(String::trim).map(part -> part.split(":", 2)).peek(kv -> {
            if (((String[])kv).length != 2) {
                throw new IllegalArgumentException("Invalid segment: '" + String.join((CharSequence)":", kv) + "', expected format 'key:value'");
            }
        }).collect(Collectors.toMap(kv -> kv[0].trim(), kv -> {
            try {
                return Integer.parseInt(kv[1].trim());
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Invalid value for key '" + kv[0] + "' : '" + kv[1] + "'", ex);
            }
        }));
        if (!(values.containsKey("x") && values.containsKey("y") && values.containsKey("z"))) {
            throw new IllegalArgumentException("Missing keys: expected 'x', 'y' and 'z', found " + String.valueOf(values.keySet()));
        }
        return Position.of(values.get("x"), values.get("y"), values.get("z"));
    }
}

