/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.util.render;

import com.mojang.blaze3d.systems.RenderSystem;
import fr.siroz.cariboustonks.util.render.CustomRenderLayers;
import fr.siroz.cariboustonks.util.render.gui.Point;
import java.awt.Color;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public final class GuiRenderUtils {
    private GuiRenderUtils() {
    }

    public static boolean pointIsInArea(double x, double y, double x1, double y1, double x2, double y2) {
        return x >= x1 && x <= x2 && y >= y1 && y <= y2;
    }

    public static boolean mouseIsInArea(double mouseX, double mouseY, int x, int y, int width, int height) {
        return mouseX >= (double)x && mouseX <= (double)(x + width) && mouseY >= (double)y && mouseY <= (double)(y + height);
    }

    public static void renderLinesFromPoints(@NotNull class_332 context, @NotNull Point[] points, @NotNull Color color, float lineWidth) {
        GL11.glEnable((int)2848);
        GL11.glHint((int)3154, (int)4354);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.lineWidth((float)lineWidth);
        context.method_64039(consumerProvider -> {
            class_4588 buffer = consumerProvider.getBuffer((class_1921)CustomRenderLayers.GUI_LINES);
            class_4587 matrices = context.method_51448();
            for (int i = 0; i < points.length; ++i) {
                Point nextPoint = points[i + 1 == points.length ? i - 1 : i + 1];
                class_4587.class_4665 entry = matrices.method_23760();
                Matrix4f matrix4f = entry.method_23761();
                class_243 normalized = new class_243((double)(nextPoint.x() - points[i].x()), (double)(nextPoint.y() - points[i].y()), 0.0).method_1029();
                buffer.method_22918(matrix4f, (float)points[i].x(), (float)points[i].y(), -1.0f).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_60831(entry, (float)normalized.field_1352, (float)normalized.field_1351, (float)normalized.field_1350);
                buffer.method_22918(matrix4f, (float)nextPoint.x(), (float)nextPoint.y(), -1.0f).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_60831(entry, (float)normalized.field_1352, (float)normalized.field_1351, (float)normalized.field_1350);
            }
        });
        GL11.glDisable((int)2848);
        RenderSystem.lineWidth((float)1.0f);
    }

    public static void drawGradientRect(@NotNull class_332 context, @NotNull Matrix4f matrix4f, int zLevel, int left, int top, int right, int bottom, int startColor, int endColor) {
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        context.method_64039(consumerProvider -> {
            class_4588 buffer = consumerProvider.getBuffer((class_1921)CustomRenderLayers.GUI_QUADS);
            buffer.method_22918(matrix4f, (float)right, (float)top, (float)zLevel).method_22914((float)right, (float)top, (float)zLevel).method_22915(startRed, startGreen, startBlue, startAlpha);
            buffer.method_22918(matrix4f, (float)left, (float)top, (float)zLevel).method_22914((float)right, (float)top, (float)zLevel).method_22915(startRed, startGreen, startBlue, startAlpha);
            buffer.method_22918(matrix4f, (float)left, (float)bottom, (float)zLevel).method_22914((float)right, (float)top, (float)zLevel).method_22915(endRed, endGreen, endBlue, endAlpha);
            buffer.method_22918(matrix4f, (float)right, (float)bottom, (float)zLevel).method_22914((float)right, (float)top, (float)zLevel).method_22915(endRed, endGreen, endBlue, endAlpha);
        });
    }
}

