/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.util.render;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.util.colors.Color;
import fr.siroz.cariboustonks.util.colors.Colors;
import fr.siroz.cariboustonks.util.render.CustomRenderLayers;
import fr.siroz.cariboustonks.util.render.CustomRenderPipelines;
import fr.siroz.cariboustonks.util.render.FrustumUtils;
import fr.siroz.cariboustonks.util.render.Texture;
import fr.siroz.cariboustonks.util.render.animation.AnimationUtils;
import java.util.Objects;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5481;
import net.minecraft.class_822;
import net.minecraft.class_9799;
import net.minecraft.class_9974;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public final class WorldRenderUtils {
    private static final class_2960 TRANSLUCENT_DRAW = CaribouStonks.identifier("translucent_draw");
    private static final class_9799 ALLOCATOR = new class_9799(1536);
    private static final int MAX_BUILD_HEIGHT = 300;

    private WorldRenderUtils() {
    }

    @ApiStatus.Internal
    public static void initRenderUtilities() {
        CustomRenderPipelines.init();
        CustomRenderLayers.init();
        WorldRenderEvents.AFTER_TRANSLUCENT.addPhaseOrdering(Event.DEFAULT_PHASE, TRANSLUCENT_DRAW);
        WorldRenderEvents.AFTER_TRANSLUCENT.register(TRANSLUCENT_DRAW, WorldRenderUtils::drawTranslucent);
    }

    private static void drawTranslucent(@NotNull WorldRenderContext context) {
        class_4597.class_4598 immediate = (class_4597.class_4598)context.consumers();
        assert (immediate != null);
        immediate.method_22993();
    }

    public static void renderText(@NotNull WorldRenderContext context, @NotNull class_2561 text, @NotNull class_243 position, boolean throughBlocks) {
        WorldRenderUtils.renderText(context, text, position, 1.0f, throughBlocks);
    }

    public static void renderText(@NotNull WorldRenderContext context, @NotNull class_2561 text, @NotNull class_243 position, float scale, boolean throughBlocks) {
        WorldRenderUtils.renderText(context, text, position, scale, 0.0f, throughBlocks);
    }

    public static void renderText(@NotNull WorldRenderContext context, @NotNull class_2561 text, @NotNull class_243 position, float scale, float offsetY, boolean throughBlocks) {
        WorldRenderUtils.renderText(context, text.method_30937(), position, scale, offsetY, throughBlocks);
    }

    public static void renderText(@NotNull WorldRenderContext context, @NotNull class_5481 text, @NotNull class_243 position, float scale, float offsetY, boolean throughBlocks) {
        Matrix4f matrix4f = new Matrix4f();
        class_4184 camera = context.camera();
        class_243 cameraPos = camera.method_19326();
        class_327 textRenderer = class_310.method_1551().field_1772;
        double dx = position.method_10216() - cameraPos.method_10216();
        double dy = position.method_10214() - cameraPos.method_10214();
        double dz = position.method_10215() - cameraPos.method_10215();
        matrix4f.translate((float)dx, (float)dy, (float)dz).rotate((Quaternionfc)camera.method_23767()).scale(scale *= 0.025f, -scale, scale);
        float xOffset = (float)(-textRenderer.method_30880(text)) / 2.0f;
        class_4597.class_4598 vertex = class_4597.method_22991((class_9799)ALLOCATOR);
        textRenderer.method_22942(text, xOffset, offsetY, -1, false, matrix4f, (class_4597)vertex, throughBlocks ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993, 0, 0xF000F0);
        vertex.method_22993();
    }

    public static void renderTexture(@NotNull WorldRenderContext context, @NotNull class_243 position, float width, float height, float textureWidth, float textureHeight, @NotNull class_243 renderOffset, @NotNull Texture texture, @NotNull Color color, float alpha, boolean throughBlocks) {
        WorldRenderUtils.renderTexture(context, position, width, height, textureWidth, textureHeight, renderOffset, texture.getIdentifier(), color, alpha, throughBlocks);
    }

    public static void renderTexture(@NotNull WorldRenderContext context, @NotNull class_243 position, float width, float height, float textureWidth, float textureHeight, @NotNull class_243 renderOffset, @NotNull class_2960 texture, @NotNull Color color, float alpha, boolean throughBlocks) {
        class_1921.class_4687 layer;
        Matrix4f matrix4f = new Matrix4f();
        class_4184 camera = context.camera();
        class_243 cameraPos = camera.method_19326();
        double dx = position.method_10216() - cameraPos.field_1352;
        double dy = position.method_10214() - cameraPos.field_1351;
        double dz = position.method_10215() - cameraPos.field_1350;
        matrix4f.translate((float)dx, (float)dy, (float)dz).rotate((Quaternionfc)camera.method_23767());
        class_4597.class_4598 consumers = (class_4597.class_4598)context.consumers();
        class_1921.class_4687 class_46872 = layer = throughBlocks ? CustomRenderLayers.getTextureThroughBlocks(texture) : CustomRenderLayers.getTexture(texture);
        assert (consumers != null);
        class_4588 buffer = consumers.getBuffer((class_1921)layer);
        float[] colorComponents = color.asFloatComponents();
        buffer.method_22918(matrix4f, (float)renderOffset.method_10216(), (float)renderOffset.method_10214(), (float)renderOffset.method_10215()).method_22913(1.0f, 1.0f + textureHeight).method_22915(colorComponents[0], colorComponents[1], colorComponents[2], alpha);
        buffer.method_22918(matrix4f, (float)renderOffset.method_10216(), (float)renderOffset.method_10214() + height, (float)renderOffset.method_10215()).method_22913(1.0f, 1.0f).method_22915(colorComponents[0], colorComponents[1], colorComponents[2], alpha);
        buffer.method_22918(matrix4f, (float)renderOffset.method_10216() + width, (float)renderOffset.method_10214() + height, (float)renderOffset.method_10215()).method_22913(1.0f + textureWidth, 1.0f).method_22915(colorComponents[0], colorComponents[1], colorComponents[2], alpha);
        buffer.method_22918(matrix4f, (float)renderOffset.method_10216() + width, (float)renderOffset.method_10214(), (float)renderOffset.method_10215()).method_22913(1.0f + textureWidth, 1.0f + textureHeight).method_22915(colorComponents[0], colorComponents[1], colorComponents[2], alpha);
        consumers.method_22994((class_1921)layer);
    }

    public static void renderCircle(@NotNull WorldRenderContext context, @NotNull class_243 center, @Range(from=1L, to=32L) double radius, @Range(from=8L, to=64L) int segments, float thicknessPercent, @NotNull Color color, @NotNull class_2350.class_2351 axis, boolean throughBlocks) {
        class_1921.class_4687 layer;
        Matrix4f matrix4f = new Matrix4f();
        class_243 cameraPos = context.camera().method_19326();
        matrix4f.translate((float)(-cameraPos.field_1352), (float)(-cameraPos.field_1351), (float)(-cameraPos.field_1350));
        class_4597.class_4598 consumers = (class_4597.class_4598)context.consumers();
        class_1921.class_4687 class_46872 = layer = throughBlocks ? CustomRenderLayers.CIRCLES_THROUGH_BLOCKS : CustomRenderLayers.CIRCLES;
        assert (consumers != null);
        class_4588 buffer = consumers.getBuffer((class_1921)layer);
        thicknessPercent = Math.max(0.01f, Math.min(thicknessPercent, 0.95f));
        float thickness = (float)(radius * (double)thicknessPercent);
        for (int i = 0; i <= segments; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)segments;
            float sin = (float)Math.sin(angle);
            float cos = (float)Math.cos(angle);
            float outerX = (float)center.field_1352;
            float outerY = (float)center.field_1351;
            float outerZ = (float)center.field_1350;
            float innerX = (float)center.field_1352;
            float innerY = (float)center.field_1351;
            float innerZ = (float)center.field_1350;
            switch (axis) {
                case field_11048: {
                    outerY += (float)((radius + (double)thickness) * (double)cos);
                    outerZ += (float)((radius + (double)thickness) * (double)sin);
                    innerY += (float)((radius - (double)thickness) * (double)cos);
                    innerZ += (float)((radius - (double)thickness) * (double)sin);
                    break;
                }
                case field_11052: {
                    outerX += (float)((radius + (double)thickness) * (double)cos);
                    outerZ += (float)((radius + (double)thickness) * (double)sin);
                    innerX += (float)((radius - (double)thickness) * (double)cos);
                    innerZ += (float)((radius - (double)thickness) * (double)sin);
                    break;
                }
                case field_11051: {
                    outerX += (float)((radius + (double)thickness) * (double)cos);
                    outerY += (float)((radius + (double)thickness) * (double)sin);
                    innerX += (float)((radius - (double)thickness) * (double)cos);
                    innerY += (float)((radius - (double)thickness) * (double)sin);
                    break;
                }
            }
            buffer.method_22918(matrix4f, outerX, outerY, outerZ).method_1336(color.r, color.g, color.b, color.a);
            buffer.method_22918(matrix4f, innerX, innerY, innerZ).method_1336(color.r, color.g, color.b, color.a);
        }
        consumers.method_22994((class_1921)layer);
    }

    public static void renderThickCircle(@NotNull WorldRenderContext context, @NotNull class_243 center, @Range(from=1L, to=32L) double radius, double thickness, @Range(from=8L, to=64L) int segments, @NotNull Color color, boolean throughBlocks) {
        class_1921.class_4687 layer;
        Matrix4f matrix4f = new Matrix4f();
        class_243 cameraPos = context.camera().method_19326();
        class_243 centerTop = center.method_1031(0.0, thickness, 0.0);
        matrix4f.translate((float)(-cameraPos.field_1352), (float)(-cameraPos.field_1351), (float)(-cameraPos.field_1350));
        class_4597.class_4598 consumers = (class_4597.class_4598)context.consumers();
        class_1921.class_4687 class_46872 = layer = throughBlocks ? CustomRenderLayers.CIRCLES_THROUGH_BLOCKS : CustomRenderLayers.CIRCLES;
        assert (consumers != null);
        class_4588 buffer = consumers.getBuffer((class_1921)layer);
        for (int i = 0; i <= segments; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)segments;
            float cos = (float)Math.cos(angle);
            float sin = (float)Math.sin(angle);
            float xLower = (float)(center.field_1352 + radius * (double)cos);
            float zLower = (float)(center.field_1350 + radius * (double)sin);
            float xUpper = (float)(center.field_1352 + radius * (double)cos);
            float zUpper = (float)(center.field_1350 + radius * (double)sin);
            buffer.method_22918(matrix4f, xUpper, (float)centerTop.field_1351, zUpper).method_1336(color.r, color.g, color.b, color.a);
            buffer.method_22918(matrix4f, xLower, (float)center.field_1351, zLower).method_1336(color.r, color.g, color.b, color.a);
        }
        consumers.method_22994((class_1921)layer);
    }

    public static void renderQuad(@NotNull WorldRenderContext context, @NotNull class_243[] points, @NotNull Color color, float alpha, boolean throughBlocks) {
        class_1921.class_4687 layer;
        Matrix4f matrix4f = new Matrix4f();
        class_243 cameraPos = context.camera().method_19326();
        float[] colorComponents = color.asFloatComponents();
        matrix4f.translate((float)(-cameraPos.field_1352), (float)(-cameraPos.field_1351), (float)(-cameraPos.field_1350));
        class_4597.class_4598 consumers = (class_4597.class_4598)context.consumers();
        class_1921.class_4687 class_46872 = layer = throughBlocks ? CustomRenderLayers.QUADS_THROUGH_BLOCKS : CustomRenderLayers.QUADS;
        assert (consumers != null);
        class_4588 buffer = consumers.getBuffer((class_1921)layer);
        for (int i = 0; i < 4; ++i) {
            buffer.method_22918(matrix4f, (float)points[i].method_10216(), (float)points[i].method_10214(), (float)points[i].method_10215()).method_22915(colorComponents[0], colorComponents[1], colorComponents[2], alpha);
        }
        consumers.method_22994((class_1921)layer);
    }

    public static void renderFilledWithBeaconBeam(@NotNull WorldRenderContext context, @NotNull class_2338 position, @NotNull Color color, float alpha, boolean throughBlocks) {
        WorldRenderUtils.renderFilled(context, position, color, alpha, throughBlocks);
        WorldRenderUtils.renderBeaconBeam(context, position, color);
    }

    public static void renderFilled(@NotNull WorldRenderContext context, @NotNull class_2338 pos, @NotNull Color color, float alpha, boolean throughBlocks) {
        WorldRenderUtils.renderFilled(context, pos.method_10263(), pos.method_10264(), pos.method_10260(), pos.method_10263() + 1, pos.method_10264() + 1, pos.method_10260() + 1, color, alpha, throughBlocks);
    }

    public static void renderFilled(@NotNull WorldRenderContext context, @NotNull class_243 pos, @NotNull class_243 dimensions, @NotNull Color color, float alpha, boolean throughBlocks) {
        WorldRenderUtils.renderFilled(context, pos.field_1352, pos.field_1351, pos.field_1350, pos.field_1352 + dimensions.field_1352, pos.field_1351 + dimensions.field_1351, pos.field_1350 + dimensions.field_1350, color, alpha, throughBlocks);
    }

    public static void renderFilled(@NotNull WorldRenderContext context, @NotNull class_238 box, @NotNull Color color, float alpha, boolean throughBlocks) {
        WorldRenderUtils.renderFilled(context, box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324, color, alpha, throughBlocks);
    }

    public static void renderFilled(@NotNull WorldRenderContext context, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, @NotNull Color color, float alpha, boolean throughBlocks) {
        if (FrustumUtils.isVisible(minX, minY, minZ, maxX, maxY, maxZ)) {
            WorldRenderUtils.renderFilledInternal(context, minX, minY, minZ, maxX, maxY, maxZ, color, alpha, throughBlocks);
        }
    }

    private static void renderFilledInternal(@NotNull WorldRenderContext context, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, @NotNull Color color, float alpha, boolean throughBlocks) {
        class_4587 matrices = context.matrixStack();
        class_243 camera = context.camera().method_19326();
        boolean rainbow = false;
        if (color == Colors.RAINBOW) {
            rainbow = true;
            int colorInt = AnimationUtils.getCurrentRainbowColor().withAlpha(1.0f).asInt();
            color = Color.fromInt(colorInt);
        }
        assert (matrices != null);
        matrices.method_22903();
        matrices.method_22904(-camera.field_1352, -camera.field_1351, -camera.field_1350);
        class_4597 consumers = context.consumers();
        assert (consumers != null);
        class_4588 buffer = consumers.getBuffer((class_1921)(throughBlocks ? CustomRenderLayers.FILLED_THROUGH_BLOCKS : CustomRenderLayers.FILLED));
        float[] colorComponents = color.asFloatComponents();
        class_9974.method_62300((class_4587)matrices, (class_4588)buffer, (double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (float)colorComponents[0], (float)colorComponents[1], (float)colorComponents[2], (float)(rainbow ? 1.0f : alpha));
        matrices.method_22909();
    }

    public static void renderBeaconBeam(@NotNull WorldRenderContext context, @NotNull class_2338 position, @NotNull Color color) {
        if (FrustumUtils.isVisible(position.method_10263(), position.method_10264(), position.method_10260(), position.method_10263() + 1, 300.0, position.method_10260() + 1)) {
            class_4587 stack = context.matrixStack();
            class_243 cameraPos = context.camera().method_19326();
            assert (stack != null);
            stack.method_22903();
            double dx = (double)position.method_10263() - cameraPos.field_1352;
            double dy = (double)position.method_10264() - cameraPos.field_1351;
            double dz = (double)position.method_10260() - cameraPos.field_1350;
            stack.method_22904(dx, dy, dz);
            int colorInt = color == Colors.RAINBOW ? AnimationUtils.getCurrentRainbowColor().withAlpha(1.0f).asInt() : color.withAlpha(1.0f).asInt();
            float length = (float)cameraPos.method_1020(position.method_46558()).method_37267();
            float scale = Math.max(1.0f, length / 96.0f);
            class_822.method_3545((class_4587)stack, (class_4597)Objects.requireNonNull(context.consumers()), (class_2960)class_822.field_4338, (float)context.tickCounter().method_60637(true), (float)scale, (long)context.world().method_8510(), (int)0, (int)300, (int)colorInt, (float)0.2f, (float)0.25f);
            stack.method_22909();
        }
    }

    public static void renderOutline(@NotNull WorldRenderContext context, @NotNull class_238 box, @NotNull Color color, float lineWidth, boolean throughBlocks) {
        WorldRenderUtils.renderOutline(context, box, color, 1.0f, lineWidth, throughBlocks);
    }

    public static void renderOutline(@NotNull WorldRenderContext context, @NotNull class_238 box, @NotNull Color color, float alpha, float lineWidth, boolean throughBlocks) {
        if (FrustumUtils.isVisible(box)) {
            class_1921.class_4687 layer;
            class_4587 matrices = context.matrixStack();
            class_243 camera = context.camera().method_19326();
            float[] colorComponents = color.asFloatComponents();
            assert (matrices != null);
            matrices.method_22903();
            matrices.method_22904(-camera.method_10216(), -camera.method_10214(), -camera.method_10215());
            class_4597.class_4598 consumers = (class_4597.class_4598)context.consumers();
            class_1921.class_4687 class_46872 = layer = throughBlocks ? CustomRenderLayers.getLinesThroughBlocks(lineWidth) : CustomRenderLayers.getLines(lineWidth);
            assert (consumers != null);
            class_4588 buffer = consumers.getBuffer((class_1921)layer);
            class_9974.method_62295((class_4587)matrices, (class_4588)buffer, (class_238)box, (float)colorComponents[0], (float)colorComponents[1], (float)colorComponents[2], (float)alpha);
            consumers.method_22994((class_1921)layer);
            matrices.method_22909();
        }
    }

    public static void renderLinesFromPoints(@NotNull WorldRenderContext context, class_243 @NotNull [] points, @NotNull Color color, float lineWidth, boolean throughBlocks) {
        class_1921.class_4687 layer;
        class_243 cameraPos = context.camera().method_19326();
        class_4587 stack = context.matrixStack();
        assert (stack != null);
        stack.method_22903();
        stack.method_22904(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
        class_4587.class_4665 entry = stack.method_23760();
        class_4597.class_4598 consumers = (class_4597.class_4598)context.consumers();
        class_1921.class_4687 class_46872 = layer = throughBlocks ? CustomRenderLayers.getLinesThroughBlocks(lineWidth) : CustomRenderLayers.getLines(lineWidth);
        assert (consumers != null);
        class_4588 buffer = consumers.getBuffer((class_1921)layer);
        for (int i = 0; i < points.length; ++i) {
            class_243 nextPoint = points[i + 1 == points.length ? i - 1 : i + 1];
            Vector3f normalVec = nextPoint.method_46409().sub((float)points[i].method_10216(), (float)points[i].method_10214(), (float)points[i].method_10215()).normalize();
            if (i + 1 == points.length) {
                normalVec.negate();
            }
            buffer.method_56824(entry, (float)points[i].method_10216(), (float)points[i].method_10214(), (float)points[i].method_10215()).method_1336(color.r, color.g, color.b, color.a).method_61959(entry, normalVec);
        }
        consumers.method_22994((class_1921)layer);
        stack.method_22909();
    }

    public static void renderLineFromCursor(@NotNull WorldRenderContext context, @NotNull class_243 point, @NotNull Color color, float lineWidth) {
        class_243 cameraPos = context.camera().method_19326();
        class_4587 stack = context.matrixStack();
        assert (stack != null);
        stack.method_22903();
        stack.method_22904(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
        class_4587.class_4665 entry = stack.method_23760();
        class_4597.class_4598 consumers = (class_4597.class_4598)context.consumers();
        class_1921.class_4687 layer = CustomRenderLayers.getLines(lineWidth);
        assert (consumers != null);
        class_4588 buffer = consumers.getBuffer((class_1921)layer);
        class_243 cameraPoint = cameraPos.method_1019(class_243.method_1030((float)context.camera().method_19329(), (float)context.camera().method_19330()));
        Vector3f normal = point.method_46409().sub((float)cameraPoint.field_1352, (float)cameraPoint.field_1351, (float)cameraPoint.field_1350).normalize();
        buffer.method_56824(entry, (float)cameraPoint.field_1352, (float)cameraPoint.field_1351, (float)cameraPoint.field_1350).method_1336(color.r, color.g, color.b, color.a).method_61959(entry, normal);
        buffer.method_56824(entry, (float)point.method_10216(), (float)point.method_10214(), (float)point.method_10215()).method_1336(color.r, color.g, color.b, color.a).method_61959(entry, normal);
        consumers.method_22994((class_1921)layer);
        stack.method_22909();
    }

    @Deprecated
    public static class_243 @NotNull [] createCircle(@NotNull class_243 center, double radius, int segments, @NotNull class_2350.class_2351 axis) {
        class_243[] points = new class_243[segments + 1];
        for (int i = 0; i <= segments; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)segments;
            float sin = (float)Math.sin(angle);
            float cos = (float)Math.cos(angle);
            float x = (float)center.field_1352;
            float y = (float)center.field_1351;
            float z = (float)center.field_1350;
            switch (axis) {
                case field_11048: {
                    y += (float)(radius * (double)cos);
                    z += (float)(radius * (double)sin);
                    break;
                }
                case field_11052: {
                    x += (float)(radius * (double)cos);
                    z += (float)(radius * (double)sin);
                    break;
                }
                case field_11051: {
                    x += (float)(radius * (double)cos);
                    y += (float)(radius * (double)sin);
                    break;
                }
            }
            points[i] = new class_243((double)x, (double)y, (double)z);
        }
        return points;
    }
}

