/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.ConfigField;
import dev.isxander.yacl3.config.v2.api.ConfigSerializer;
import dev.isxander.yacl3.config.v2.api.FieldAccess;
import fr.siroz.cariboustonks.mixin.accessors.ConfigClassHandlerImplAccessor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@ApiStatus.Internal
final class GsonConfigSerializer<T>
extends ConfigSerializer<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Path path;
    private final Gson gson;

    GsonConfigSerializer(@NotNull ConfigClassHandler<T> config, @NotNull Path path, @NotNull UnaryOperator<GsonBuilder> builder) {
        super(config);
        this.path = path;
        this.gson = ((GsonBuilder)builder.apply(new GsonBuilder())).create();
    }

    public void save() {
        Object instance = this.config.instance();
        try {
            String json = this.gson.toJson(instance);
            Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
            Files.writeString(this.path, (CharSequence)json, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
            LOGGER.info("[CaribouStonks Config] Successfully saved to {}.", (Object)this.path);
        }
        catch (Exception ex) {
            LOGGER.error(LogUtils.FATAL_MARKER, "[CaribouStonks Config] Unable to save file to: {}", (Object)this.path, (Object)ex);
        }
    }

    public ConfigSerializer.LoadResult loadSafely(Map<ConfigField<?>, FieldAccess<?>> bufferAccessMap) {
        try {
            if (!Files.exists(this.path, new LinkOption[0])) {
                ((ConfigClassHandlerImplAccessor)this.config).setInstance(this.createNewConfigInstance());
                this.save();
                return ConfigSerializer.LoadResult.NO_CHANGE;
            }
        }
        catch (Exception ex) {
            LOGGER.error("[CaribouStonks Config] Failed to create the default config file", (Throwable)ex);
        }
        try {
            String config = Files.readString(this.path);
            Object instance = this.gson.fromJson(JsonParser.parseString((String)config), this.config.configClass());
            ((ConfigClassHandlerImplAccessor)this.config).setInstance(instance);
            LOGGER.info("[CaribouStonks Config] Successfully loaded from {}", (Object)this.path);
        }
        catch (Exception ex) {
            LOGGER.error(LogUtils.FATAL_MARKER, "[CaribouStonks Config] Failed to load the config :/", (Throwable)ex);
        }
        return ConfigSerializer.LoadResult.NO_CHANGE;
    }

    @Nullable
    private T createNewConfigInstance() {
        try {
            return this.config.configClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            LOGGER.error("[CaribouStonks Config] Failed to create a new config instance", (Throwable)ex);
            return null;
        }
    }
}

