/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.core.HypixelModAPI;
import fr.siroz.cariboustonks.core.UpdateChecker;
import fr.siroz.cariboustonks.core.WelcomeMessage;
import fr.siroz.cariboustonks.core.changelog.ChangelogManager;
import fr.siroz.cariboustonks.core.crash.CrashManager;
import fr.siroz.cariboustonks.core.data.generic.GenericDataSource;
import fr.siroz.cariboustonks.core.data.hypixel.HypixelDataSource;
import fr.siroz.cariboustonks.core.data.mod.ModDataSource;
import fr.siroz.cariboustonks.core.dev.DeveloperManager;
import fr.siroz.cariboustonks.core.json.JsonFileService;
import fr.siroz.cariboustonks.core.scheduler.TickScheduler;
import fr.siroz.cariboustonks.core.skyblock.IslandType;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.event.SkyBlockEvents;
import fr.siroz.cariboustonks.util.DeveloperTools;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import org.jetbrains.annotations.ApiStatus;

public final class CaribouStonksCore {
    private final CrashManager crashManager;
    private final JsonFileService jsonFileService;
    private final ModDataSource modDataSource;
    private final HypixelDataSource hypixelDataSource;
    private final GenericDataSource genericDataSource;

    @ApiStatus.Internal
    public CaribouStonksCore() {
        CaribouStonks.LOGGER.info("[CaribouStonksCore] Loading..");
        this.crashManager = new CrashManager();
        this.jsonFileService = new JsonFileService();
        new UpdateChecker();
        new ChangelogManager();
        new HypixelModAPI();
        new WelcomeMessage();
        this.modDataSource = new ModDataSource();
        this.hypixelDataSource = new HypixelDataSource(this.modDataSource);
        this.genericDataSource = new GenericDataSource();
        TickScheduler.getInstance().runRepeating(SkyBlockAPI::handleInternalUpdate, 3, TimeUnit.SECONDS);
        ClientPlayConnectionEvents.DISCONNECT.register((_handler, _client) -> this.onDisconnect());
        CaribouStonks.LOGGER.info("[CaribouStonksCore] Loaded!");
    }

    @ApiStatus.Internal
    public void initDeveloperMode() {
        if (DeveloperTools.isInDevelopment()) {
            new DeveloperManager();
        }
    }

    public CrashManager getCrashManager() {
        return this.crashManager;
    }

    public JsonFileService getJsonFileService() {
        return this.jsonFileService;
    }

    public ModDataSource getModDataSource() {
        return this.modDataSource;
    }

    public HypixelDataSource getHypixelDataSource() {
        return this.hypixelDataSource;
    }

    public GenericDataSource getGenericDataSource() {
        return this.genericDataSource;
    }

    private void onDisconnect() {
        if (SkyBlockAPI.isOnSkyBlock()) {
            ((SkyBlockEvents.Leave)SkyBlockEvents.LEAVE.invoker()).onLeave();
        }
        SkyBlockAPI.handleInternalLocationUpdate(null, false, "", IslandType.UNKNOWN);
    }
}

