/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.core.json.GsonProvider;
import fr.siroz.cariboustonks.core.scheduler.AsyncScheduler;
import fr.siroz.cariboustonks.core.scheduler.TickScheduler;
import fr.siroz.cariboustonks.event.SkyBlockEvents;
import fr.siroz.cariboustonks.util.Client;
import fr.siroz.cariboustonks.util.http.Http;
import fr.siroz.cariboustonks.util.http.HttpResponse;
import fr.siroz.cariboustonks.util.render.notification.Notification;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3417;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class UpdateChecker {
    private static final String MODRINTH_VERSION_URL = "https://modrinth.com/mod/cariboustonks/version/";
    private static final String MODRINTH_VERSION_CHECKER_URL = "https://api.modrinth.com/v2/project/fraWWQSJ/version?loaders=[%22fabric%22]&game_versions=";
    private static final Comparator<Version> COMPARATOR = Comparable::compareTo;
    private ModrinthVersionInfo newestModrinthVersionInfo = null;
    private boolean notified = false;

    UpdateChecker() {
        ClientLifecycleEvents.CLIENT_STARTED.register(_client -> this.checkUpdateOnModrinth());
        SkyBlockEvents.JOIN.register(_s -> this.onJoinSkyBlock());
    }

    private void checkUpdateOnModrinth() {
        String mcVersion = class_155.method_16673().comp_4024();
        CompletableFuture.runAsync(() -> {
            try (HttpResponse response = Http.request("https://api.modrinth.com/v2/project/fraWWQSJ/version?loaders=[%22fabric%22]&game_versions=[%22" + mcVersion + "%22]");){
                if (!response.success()) {
                    CaribouStonks.LOGGER.warn("[CaribouStonks UpdateChecker] Unable to fetch Modrinth API, code: {}", (Object)response.statusCode());
                    return;
                }
                JsonArray jsonResponse = (JsonArray)GsonProvider.prettyPrinting().fromJson(response.content(), JsonArray.class);
                if (jsonResponse == null || jsonResponse.isEmpty()) {
                    CaribouStonks.LOGGER.info("[CaribouStonks UpdateChecker] No versions available on this version!");
                    return;
                }
                ArrayList<ModrinthVersionInfo> modrinthVersionInfos = new ArrayList<ModrinthVersionInfo>();
                for (JsonElement element : jsonResponse) {
                    JsonObject jsonObject = element.getAsJsonObject();
                    String id = jsonObject.get("id").getAsString();
                    String name = jsonObject.get("name").getAsString();
                    SemanticVersion version = this.getVersionFromString(jsonObject.get("version_number").getAsString());
                    modrinthVersionInfos.add(new ModrinthVersionInfo(id, name, version, null));
                }
                SemanticVersion currentVersion = (SemanticVersion)CaribouStonks.VERSION;
                Optional<ModrinthVersionInfo> newestModrinthVersionInfo = modrinthVersionInfos.stream().filter(info -> COMPARATOR.compare((Version)info.version(), (Version)currentVersion) > 0).max(Comparator.comparing(ModrinthVersionInfo::version, COMPARATOR));
                if (newestModrinthVersionInfo.isPresent()) {
                    this.newestModrinthVersionInfo = newestModrinthVersionInfo.get();
                    CaribouStonks.LOGGER.info("[CaribouStonks UpdateChecker] Found a new version! o/ ({} -> {})", (Object)CaribouStonks.VERSION.getFriendlyString(), (Object)newestModrinthVersionInfo.get().version().getFriendlyString());
                } else {
                    CaribouStonks.LOGGER.info("[CaribouStonks UpdateChecker] Up to the date!");
                }
            }
            catch (Exception ex) {
                CaribouStonks.LOGGER.error("[CaribouStonks UpdateChecker] Failed to check updates on Modrinth :/", (Throwable)ex);
            }
        }, AsyncScheduler.getInstance().blockingExecutor());
    }

    private void onJoinSkyBlock() {
        if (this.notified || this.newestModrinthVersionInfo == null) {
            return;
        }
        this.notified = true;
        TickScheduler.getInstance().runLater(() -> {
            Client.sendMessage((class_2561)class_2561.method_43473());
            Client.sendMessageWithPrefix((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"?i").method_27695(new class_124[]{class_124.field_1065, class_124.field_1051})).method_10852((class_2561)class_2561.method_43470((String)" Update Available! ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"i?").method_27695(new class_124[]{class_124.field_1065, class_124.field_1051})));
            Client.sendMessageWithPrefix((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)this.newestModrinthVersionInfo.name()).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" CLICK").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067})).method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to open on Modrinth!").method_27692(class_124.field_1054))).method_10958((class_2558)new class_2558.class_10608(URI.create(MODRINTH_VERSION_URL + this.newestModrinthVersionInfo.id())))));
            Client.sendMessage((class_2561)class_2561.method_43473());
            Client.playSound(class_3417.field_50098, 1.0f, 1.0f);
            Notification.showSystem("CaribouStonks Update Available!", "Update to " + this.newestModrinthVersionInfo.version().getFriendlyString());
        }, 3, TimeUnit.SECONDS);
    }

    @NotNull
    private SemanticVersion getVersionFromString(@NotNull String versionNumber) throws VersionParsingException {
        if (versionNumber.charAt(0) == 'v') {
            versionNumber = versionNumber.substring(1);
        }
        return SemanticVersion.parse((String)versionNumber);
    }

    private record ModrinthVersionInfo(String id, String name, SemanticVersion version, @Nullable String changelog) {
    }
}

