/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core.crash;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.core.crash.CrashType;
import fr.siroz.cariboustonks.util.Client;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class CrashManager {
    private final Set<String> reportedCrashes = ConcurrentHashMap.newKeySet();

    public void reportCrash(@NotNull CrashType type, @NotNull String niceName, @NotNull String fullName, @NotNull String reason, Throwable throwable) {
        this.reportCrash(type, niceName, fullName, reason, true, true, throwable);
    }

    public void reportCrash(@NotNull CrashType type, @NotNull String niceName, @NotNull String fullName, @NotNull String reason, boolean shouldSendChat, boolean shouldSendNotification, Throwable throwable) {
        String crashSignature = fullName + "|" + reason;
        if (shouldSendChat && !this.reportedCrashes.contains(crashSignature)) {
            Client.sendErrorMessage("CaribouStonks error: " + type.getName() + " '" + niceName + "' was crashed in " + reason, shouldSendNotification);
        }
        this.reportedCrashes.add(crashSignature);
        CaribouStonks.LOGGER.warn("---------------- STONKS CRASH ----------------");
        CaribouStonks.LOGGER.warn("CrashType of {} {} due to {}", new Object[]{type.toString().toLowerCase(Locale.ROOT), niceName, reason});
        CaribouStonks.LOGGER.error("Exception thrown by {}", (Object)fullName, (Object)throwable);
        CaribouStonks.LOGGER.warn("----------------------------------------------");
    }
}

