/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core.data.hypixel.bazaar;

import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface BazaarItemAnalytics {
    public static double buyPrice(@NotNull List<Double> summaryPrices) {
        return summaryPrices.isEmpty() ? -1.0 : summaryPrices.stream().min(Double::compareTo).orElse(0.0);
    }

    public static double sellPrice(@NotNull List<Double> summaryPrices) {
        return summaryPrices.isEmpty() ? -1.0 : summaryPrices.stream().max(Double::compareTo).orElse(0.0);
    }

    public static double spread(double buyPrice, double sellPrice) {
        return buyPrice - sellPrice;
    }

    public static double spreadPercentage(double buyPrice, double sellPrice) {
        if (sellPrice == 0.0) {
            return 0.0;
        }
        return (buyPrice - sellPrice) / sellPrice * 100.0;
    }

    public static double standardDeviation(@NotNull List<Double> prices) {
        if (prices.isEmpty()) {
            return 0.0;
        }
        double mean = prices.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
        double variance = prices.stream().mapToDouble(price -> Math.pow(price - mean, 2.0)).average().orElse(0.0);
        return Math.sqrt(variance);
    }

    public static double priceVelocity(long currentVolume, long movingWeekVolume) {
        if (movingWeekVolume == 0L) {
            return 0.0;
        }
        double dailyAverage = (double)movingWeekVolume / 7.0;
        return (double)currentVolume / dailyAverage;
    }
}

