/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core.data.hypixel.fetcher;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.core.data.hypixel.HypixelAPIFixer;
import fr.siroz.cariboustonks.core.data.hypixel.HypixelDataSource;
import fr.siroz.cariboustonks.core.data.hypixel.item.SkyBlockItem;
import fr.siroz.cariboustonks.core.data.mod.ModDataSource;
import fr.siroz.cariboustonks.core.json.GsonProvider;
import fr.siroz.cariboustonks.core.scheduler.AsyncScheduler;
import fr.siroz.cariboustonks.core.scheduler.TickScheduler;
import fr.siroz.cariboustonks.util.http.Http;
import fr.siroz.cariboustonks.util.http.HttpResponse;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.http.client.HttpResponseException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ItemsFetcher {
    private static final String ITEMS_URL = "https://api.hypixel.net/v2/resources/skyblock/items";
    private static final Duration FIRST_RETRY_DELAY = Duration.ofMinutes(1L);
    private static final int MAX_RETRIES = 5;
    private final HypixelDataSource hypixelDataSource;
    private final ModDataSource modDataSource;
    private final HypixelAPIFixer apiFixer;
    private final AtomicBoolean fetchInProgress;
    private final AtomicInteger retryAttempts;
    private final AtomicBoolean lastFetchSuccessful;
    private final AtomicReference<Map<String, SkyBlockItem>> skyBlockItems;

    public ItemsFetcher(HypixelDataSource hypixelDataSource, ModDataSource modDataSource, HypixelAPIFixer apiFixer) {
        this.hypixelDataSource = hypixelDataSource;
        this.modDataSource = modDataSource;
        this.apiFixer = apiFixer;
        this.fetchInProgress = new AtomicBoolean(false);
        this.retryAttempts = new AtomicInteger(0);
        this.lastFetchSuccessful = new AtomicBoolean(false);
        this.skyBlockItems = new AtomicReference(Map.of());
    }

    public void start() {
        this.triggerFetch(false).thenRun(this.afterFetch());
    }

    public Map<String, SkyBlockItem> getSkyBlockItemsSnapshot() {
        return this.skyBlockItems.get();
    }

    public boolean isLastFetchSuccessful() {
        return this.lastFetchSuccessful.get();
    }

    public void putItem(@NotNull String key, @NotNull SkyBlockItem item) {
        this.skyBlockItems.updateAndGet(prev -> {
            HashMap<String, SkyBlockItem> mutable = new HashMap<String, SkyBlockItem>((Map<String, SkyBlockItem>)prev);
            mutable.put(key, item);
            return Map.copyOf(mutable);
        });
    }

    private CompletableFuture<Void> triggerFetch(boolean force) {
        if (!force && !this.fetchInProgress.compareAndSet(false, true)) {
            CaribouStonks.LOGGER.warn("[ItemsFetcher] Skipping fetch, already in progress");
            return CompletableFuture.completedFuture(null);
        }
        CompletionStage<Void> promise = CompletableFuture.runAsync(this::executeFetch, AsyncScheduler.getInstance().blockingExecutor());
        promise = ((CompletableFuture)promise).exceptionallyCompose(throwable -> {
            Throwable cause = throwable instanceof CompletionException ? throwable.getCause() : throwable;
            CaribouStonks.LOGGER.error("[ItemsFetcher] Fetch items failed (attempt {}). Cause: {}", (Object)this.retryAttempts.get(), (Object)cause);
            int attemptsSoFar = this.retryAttempts.getAndIncrement();
            if (attemptsSoFar >= 5) {
                CaribouStonks.LOGGER.error("[ItemsFetcher] Max retries reached, aborting fetch");
                this.fetchInProgress.set(false);
                this.lastFetchSuccessful.set(false);
            } else {
                long minutes = FIRST_RETRY_DELAY.toMinutes() << attemptsSoFar;
                CaribouStonks.LOGGER.warn("[ItemsFetcher] Retrying items fetch in {} minutes (attempt {}/{})", new Object[]{minutes, attemptsSoFar + 1, 5});
                TickScheduler.getInstance().runLater(() -> this.triggerFetch(true).thenRun(this.afterFetch()), (int)minutes, TimeUnit.MINUTES);
            }
            return CompletableFuture.completedFuture(null);
        });
        promise = ((CompletableFuture)promise).whenComplete((v, t) -> this.fetchInProgress.set(false));
        return promise;
    }

    private void executeFetch() {
        block12: {
            try (HttpResponse response = Http.request(ITEMS_URL);){
                if (!response.success()) {
                    throw new HttpResponseException(response.statusCode(), response.content());
                }
                String body = response.content();
                if (body == null || body.isBlank()) {
                    throw new RuntimeException("SkyBlock API Items Resource returned null or blank reply");
                }
                JsonObject root = JsonParser.parseString((String)body).getAsJsonObject();
                if (!root.has("success") || !root.get("success").getAsBoolean()) {
                    String cause = root.has("cause") ? root.get("cause").getAsString() : "?";
                    throw new RuntimeException("SkyBlock API Items Resource failed. Cause: " + cause);
                }
                JsonArray itemsArray = GsonProvider.safeGetAsArray(root, "items");
                Map<String, SkyBlockItem> items = this.parseItems(itemsArray);
                if (items != null && !items.isEmpty()) {
                    this.skyBlockItems.set(Map.copyOf(items));
                    this.retryAttempts.set(0);
                    this.lastFetchSuccessful.set(true);
                    break block12;
                }
                throw new RuntimeException("Unable to parse SkyBlock Items");
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private Map<String, SkyBlockItem> parseItems(@Nullable JsonArray itemsArray) {
        if (itemsArray == null) {
            return null;
        }
        HashMap<String, SkyBlockItem> items = new HashMap<String, SkyBlockItem>();
        for (int i = 0; i < itemsArray.size(); ++i) {
            String id;
            JsonObject item = itemsArray.get(i).getAsJsonObject();
            if (!item.has("id") || this.apiFixer.isBlacklisted(id = item.get("id").getAsString())) continue;
            try {
                SkyBlockItem skyBlockItem = SkyBlockItem.parse(item);
                items.put(id, skyBlockItem);
                continue;
            }
            catch (Exception ex) {
                CaribouStonks.LOGGER.error("[ItemFetcher] Unable to parse SkyBlock Item: {}", (Object)id, (Object)ex);
            }
        }
        return items;
    }

    @Contract(pure=true)
    @NotNull
    private Runnable afterFetch() {
        return () -> {
            if (this.lastFetchSuccessful.get()) {
                CaribouStonks.LOGGER.info("[ItemsFetcher] Loaded {} SkyBlock Items", (Object)this.skyBlockItems.get().size());
                this.hypixelDataSource.fixSkyBlockItems();
            }
            if (this.lastFetchSuccessful.get() && !this.modDataSource.isItemsMappingError()) {
                List hypixelMaterials = this.skyBlockItems.get().values().stream().map(SkyBlockItem::material).collect(Collectors.toSet()).stream().toList();
                for (String material : hypixelMaterials) {
                    if (this.modDataSource.containsItem(material)) continue;
                    CaribouStonks.LOGGER.warn("[ItemsFetcher] (Minecraft Ids Mapping) -> {} is not registered!", (Object)material);
                }
            } else {
                CaribouStonks.LOGGER.error("[ItemsFetcher] (Minecraft Ids Mapping) SkyBlock Items error or mapping error");
            }
        };
    }
}

