/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core.data.hypixel.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fr.siroz.cariboustonks.core.data.hypixel.item.Rarity;
import net.minecraft.class_2487;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PetInfo(@Nullable String name, @NotNull String type, @NotNull Rarity rarity) {
    public static final PetInfo EMPTY = new PetInfo(null, "", Rarity.UNKNOWN);

    @ApiStatus.Internal
    @NotNull
    public static PetInfo parse(@NotNull class_2487 data) {
        String petInfo = data.method_68564("petInfo", "");
        if (petInfo.isEmpty()) {
            return EMPTY;
        }
        try {
            JsonElement element = JsonParser.parseString((String)petInfo);
            JsonObject json = element.getAsJsonObject();
            String name = json.has("name") ? json.get("name").getAsString() : null;
            String type = json.has("type") ? json.get("type").getAsString() : "";
            Rarity rarity = Rarity.fromName(json.has("tier") ? json.get("tier").getAsString() : null);
            return new PetInfo(name, type, rarity);
        }
        catch (Exception exception) {
            return EMPTY;
        }
    }
}

