/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core.data.hypixel.item;

import com.google.gson.JsonObject;
import fr.siroz.cariboustonks.core.data.hypixel.item.Rarity;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record SkyBlockItem(@NotNull String skyBlockId, @NotNull String material, @NotNull String name, @NotNull Rarity tier, @Nullable String skullTexture) {
    @ApiStatus.Internal
    @Contract(value="_ -> new")
    @NotNull
    public static SkyBlockItem parse(@NotNull JsonObject jsonItem) throws RuntimeException {
        try {
            String id = jsonItem.get("id").getAsString();
            String material = jsonItem.get("material").getAsString();
            String name = jsonItem.get("name").getAsString();
            Rarity rarity = SkyBlockItem.computeTier(jsonItem);
            String skullTexture = SkyBlockItem.computeSkullTexture(jsonItem, material);
            return new SkyBlockItem(id, material, name, rarity, skullTexture);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Rarity computeTier(@NotNull JsonObject jsonItem) {
        if (jsonItem.has("tier")) {
            return Rarity.fromName(jsonItem.get("tier").getAsString());
        }
        return Rarity.UNKNOWN;
    }

    @Nullable
    private static String computeSkullTexture(@NotNull JsonObject jsonItem, String material) {
        if (jsonItem.has("skin") && "SKULL_ITEM".equals(material)) {
            JsonObject skin = jsonItem.get("skin").getAsJsonObject();
            return skin.has("value") ? skin.get("value").getAsString() : null;
        }
        return null;
    }
}

