/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core.dev;

import com.google.gson.JsonElement;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.core.dev.DebugRenderer;
import fr.siroz.cariboustonks.core.json.GsonProvider;
import fr.siroz.cariboustonks.core.scheduler.TickScheduler;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.event.NetworkEvents;
import fr.siroz.cariboustonks.event.WorldEvents;
import fr.siroz.cariboustonks.util.Client;
import fr.siroz.cariboustonks.util.DeveloperTools;
import fr.siroz.cariboustonks.util.InventoryUtils;
import fr.siroz.cariboustonks.util.ItemUtils;
import fr.siroz.cariboustonks.util.TimeUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.util.List;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_124;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_155;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2767;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.class_9322;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class DeveloperManager {
    private final Object2IntMap<class_1531> texturedArmorStands = new Object2IntOpenHashMap();
    private boolean dumpSound = false;

    public DeveloperManager() {
        CaribouStonks.LOGGER.warn("Debug mode enabled ({}) {}", (Object)class_155.method_16673().comp_4025(), (Object)(DeveloperTools.isSnapshot() ? "(Snapshot)" : ""));
        DebugRenderer debugRenderer = new DebugRenderer(this);
        ClientPlayConnectionEvents.JOIN.register(this::onPlayConnection);
        WorldEvents.ALLOW_SOUND.register(this::onSound);
        NetworkEvents.PLAY_SOUND_PACKET.register(this::onSoundPacket);
        WorldRenderEvents.AFTER_TRANSLUCENT.register(debugRenderer::render);
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, _ra) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cariboustonks").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"devtools").then(this.dumpSoundCommand())).then(this.dumpMayorCommand())).then(this.dumpHeldItemSimpleCommand())).then(this.dumpHeldItemCommand())).then(this.dumpArmorStandHeadTextures()))));
    }

    Object2IntMap<class_1531> getTexturedArmorStands() {
        return this.texturedArmorStands;
    }

    private void onPlayConnection(class_634 _handler, PacketSender _sender, class_310 _c) {
        Client.sendMessageWithPrefix((class_2561)class_2561.method_43470((String)("Debug mode enabled (" + class_155.method_16673().comp_4025() + ")")).method_27692(class_124.field_1061).method_10852((class_2561)(DeveloperTools.isSnapshot() ? class_2561.method_43470((String)" (Snapshot)").method_27692(class_124.field_1079) : class_2561.method_43473())));
    }

    private boolean onSound(@NotNull class_3414 soundEvent) {
        if (this.dumpSound) {
            String soundId = soundEvent.comp_3319().method_12832();
            String time = TimeUtils.formatInstant(Instant.now(), TimeUtils.TIME_HH_MM_SS);
            Client.sendMessage((class_2561)class_2561.method_43470((String)("(Client) " + time + " :: " + soundId)));
        }
        return true;
    }

    private void onSoundPacket(class_2767 packet) {
        if (this.dumpSound) {
            String soundId = ((class_3414)packet.method_11894().comp_349()).comp_3319().method_12832();
            String time = TimeUtils.formatInstant(Instant.now(), TimeUtils.TIME_HH_MM_SS);
            String pitch = BigDecimal.valueOf(packet.method_11892()).setScale(3, RoundingMode.DOWN).stripTrailingZeros().toPlainString();
            String volume = BigDecimal.valueOf(packet.method_11891()).setScale(3, RoundingMode.DOWN).stripTrailingZeros().toPlainString();
            Client.sendMessage((class_2561)class_2561.method_43470((String)("(Server) " + time + " :: " + soundId + " Pitch: " + pitch + " Volume: " + volume)));
        }
    }

    private LiteralArgumentBuilder<FabricClientCommandSource> dumpHeldItemSimpleCommand() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"dumpHeldItemSimple").executes(ctx -> {
            class_1799 item = ((FabricClientCommandSource)ctx.getSource()).getPlayer().method_6047();
            if (item == null || item.method_7960()) {
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)CaribouStonks.prefix().get().method_10852((class_2561)class_2561.method_43470((String)"Item is null or empty").method_27692(class_124.field_1061)));
            } else {
                class_5250 message = class_2561.method_43473();
                message.method_10852(item.method_7964()).method_27693(" :").method_27693("\n").method_27693(" - SkyBlockItemId: " + SkyBlockAPI.getSkyBlockItemId((class_9322)item)).method_27692(class_124.field_1080).method_27693("\n").method_27693(" - SkyBlockApiId: " + SkyBlockAPI.getSkyBlockApiId((class_9322)item)).method_27692(class_124.field_1080);
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)CaribouStonks.prefix().get().method_10852((class_2561)message));
            }
            return 1;
        });
    }

    private LiteralArgumentBuilder<FabricClientCommandSource> dumpHeldItemCommand() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"dumpHeldItem").executes(ctx -> {
            String json = GsonProvider.standard().toJson((JsonElement)class_1799.field_24671.encodeStart((DynamicOps)DeveloperTools.getRegistryLookup().method_57093((DynamicOps)JsonOps.INSTANCE), (Object)((FabricClientCommandSource)ctx.getSource()).getPlayer().method_6047()).getOrThrow());
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)CaribouStonks.prefix().get().method_10852((class_2561)class_2561.method_43470((String)("Debug Held Item: " + json))));
            return 1;
        });
    }

    private LiteralArgumentBuilder<FabricClientCommandSource> dumpArmorStandHeadTextures() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"dumpArmorStandHeadTextures").executes(ctx -> {
            this.texturedArmorStands.clear();
            TickScheduler.getInstance().runLater(() -> this.texturedArmorStands.clear(), 200);
            List armorStands = ((FabricClientCommandSource)ctx.getSource()).getWorld().method_8390(class_1531.class, ((FabricClientCommandSource)ctx.getSource()).getPlayer().method_5829().method_1014(8.0), class_1301.field_6153);
            int id = 0;
            for (class_1531 armorStand : armorStands) {
                this.texturedArmorStands.put((Object)armorStand, id);
                List<class_1799> equippedItems = InventoryUtils.getArmorFromEntity((class_1309)armorStand);
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)CaribouStonks.prefix().get().method_10852((class_2561)class_2561.method_43470((String)("Head texture #" + id + ": "))));
                for (class_1799 stack : equippedItems) {
                    ItemUtils.getHeadTextureOptional(stack).ifPresent(texture -> ((FabricClientCommandSource)ctx.getSource()).sendFeedback(class_2561.method_30163((String)texture)));
                }
                ++id;
            }
            return 1;
        });
    }

    private LiteralArgumentBuilder<FabricClientCommandSource> dumpSoundCommand() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"dumpSound").executes(ctx -> {
            this.dumpSound = !this.dumpSound;
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)CaribouStonks.prefix().get().method_10852((class_2561)class_2561.method_43470((String)("Dump sound: " + this.dumpSound))));
            return 1;
        });
    }

    private LiteralArgumentBuilder<FabricClientCommandSource> dumpMayorCommand() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"dumpMayor").executes(ctx -> {
            String str = CaribouStonks.core().getHypixelDataSource().getElection() != null ? CaribouStonks.core().getHypixelDataSource().getElection().toString() : "NULL";
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)CaribouStonks.prefix().get().method_10852((class_2561)class_2561.method_43470((String)"--")));
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)str));
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)CaribouStonks.prefix().get().method_10852((class_2561)class_2561.method_43470((String)"--")));
            return 1;
        });
    }
}

