/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core.scheduler;

import fr.siroz.cariboustonks.CaribouStonks;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import org.jetbrains.annotations.NotNull;

public final class AsyncScheduler {
    private static final int THREAD_POOL_SIZE = 4;
    private static final int QUEUE_CAPACITY = 64;
    private final AtomicInteger threadCounter = new AtomicInteger();
    private final ExecutorService blockingExecutor;

    private AsyncScheduler() {
        ThreadFactory threadFactory = r -> {
            Thread thread = new Thread(r, "CaribouStonks-async-" + this.threadCounter.getAndIncrement());
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler((th, ex) -> CaribouStonks.LOGGER.error("[AsyncScheduler] Uncaught exception in thread {}: {}", new Object[]{th.getName(), ex.getMessage(), ex}));
            return thread;
        };
        this.blockingExecutor = new ThreadPoolExecutor(4, 4, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(64), threadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
        ClientLifecycleEvents.CLIENT_STOPPING.register(_client -> this.shutdownBlockingExecutor());
    }

    public static AsyncScheduler getInstance() {
        return Holder.INSTANCE;
    }

    @NotNull
    public ExecutorService blockingExecutor() {
        return this.blockingExecutor;
    }

    public void submit(@NotNull Runnable task) {
        try {
            this.blockingExecutor.execute(task);
        }
        catch (RejectedExecutionException rex) {
            CaribouStonks.LOGGER.warn("[AsyncScheduler] Task rejected. Running on caller thread as fallback.", (Throwable)rex);
            try {
                task.run();
            }
            catch (Throwable t) {
                CaribouStonks.LOGGER.error("[AsyncScheduler] Fallback run failed", t);
            }
        }
    }

    public void shutdownBlockingExecutor() {
        if (this.blockingExecutor.isShutdown()) {
            return;
        }
        this.blockingExecutor.shutdown();
        try {
            if (!this.blockingExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.blockingExecutor.shutdownNow();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static final class Holder {
        private static final AsyncScheduler INSTANCE = new AsyncScheduler();

        private Holder() {
        }
    }
}

