/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core.skyblock;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.core.data.hypixel.election.ElectionResult;
import fr.siroz.cariboustonks.core.data.hypixel.election.Mayor;
import fr.siroz.cariboustonks.core.data.hypixel.election.Perk;
import fr.siroz.cariboustonks.core.data.hypixel.item.PetInfo;
import fr.siroz.cariboustonks.core.data.hypixel.item.Rarity;
import fr.siroz.cariboustonks.core.data.mod.SkyBlockAttribute;
import fr.siroz.cariboustonks.core.skyblock.IslandType;
import fr.siroz.cariboustonks.util.DeveloperTools;
import fr.siroz.cariboustonks.util.ItemUtils;
import fr.siroz.cariboustonks.util.ScoreboardUtils;
import fr.siroz.cariboustonks.util.StonksUtils;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_9322;
import net.minecraft.class_9334;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SkyBlockAPI {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final Pattern ABILITY = Pattern.compile("Ability: (?<name>.*?) *");
    private static final String ITEM_ID = "id";
    private static final String ITEM_UUID = "uuid";
    private static boolean onHypixelState = false;
    private static boolean onSkyBlockState = false;
    private static IslandType islandType = IslandType.UNKNOWN;
    private static String gameType = "";

    private SkyBlockAPI() {
        throw new UnsupportedOperationException();
    }

    public static boolean isOnSkyBlock() {
        return onSkyBlockState;
    }

    public static IslandType getIsland() {
        return islandType;
    }

    public static boolean isOnIslands(IslandType ... islandTypes) {
        if (islandTypes.length == 0) {
            return false;
        }
        if (islandTypes.length == 1) {
            return islandTypes[0] == islandType;
        }
        for (IslandType type : islandTypes) {
            if (type != islandType) continue;
            return true;
        }
        return false;
    }

    public static boolean isMayorOrMinister(@NotNull Mayor mayor) {
        return SkyBlockAPI.isMayorOrMinister(mayor, null);
    }

    public static boolean isMayorOrMinister(@NotNull Mayor mayor, @Nullable Perk perk) {
        ElectionResult result = CaribouStonks.core().getHypixelDataSource().getElection();
        if (result == null) {
            return false;
        }
        if (perk == null) {
            return mayor == result.mayor() || mayor == result.minister();
        }
        if (mayor == result.mayor()) {
            Set<Perk> mayorPerks = result.mayorPerks();
            return !mayorPerks.isEmpty() && mayorPerks.contains((Object)perk);
        }
        if (mayor == result.minister()) {
            Optional<Perk> opt = result.ministerPerk();
            return opt.isPresent() && opt.get() == perk;
        }
        return false;
    }

    @NotNull
    public static Optional<String> getArea() {
        return Optional.ofNullable(ScoreboardUtils.getIslandArea());
    }

    @NotNull
    public static String getSkyBlockItemId(@NotNull class_9322 stack) {
        return ItemUtils.getCustomData(stack).method_68564(ITEM_ID, "");
    }

    @NotNull
    public static String getSkyBlockItemUuid(@NotNull class_9322 stack) {
        return ItemUtils.getCustomData(stack).method_68564(ITEM_UUID, "");
    }

    @NotNull
    public static Rarity getRarity(@Nullable class_1799 stack) {
        if (!onSkyBlockState || stack == null || stack.method_7960()) {
            return Rarity.UNKNOWN;
        }
        if (SkyBlockAPI.getSkyBlockItemId((class_9322)stack).equals("PET")) {
            return SkyBlockAPI.getPetInfo(stack).rarity();
        }
        return ItemUtils.getLore(stack).reversed().stream().map(class_2561::getString).map(Rarity::containsName).flatMap(Optional::stream).findFirst().orElse(Rarity.UNKNOWN);
    }

    @NotNull
    public static PetInfo getPetInfo(@Nullable class_1799 stack) {
        if (!onSkyBlockState || stack == null || stack.method_7960()) {
            return PetInfo.EMPTY;
        }
        return PetInfo.parse(ItemUtils.getCustomData((class_9322)stack));
    }

    @Nullable
    public static String getAbility(@NotNull class_1799 stack) {
        Matcher abilityMatcher = ItemUtils.getLoreLineIfMatch(stack, ABILITY);
        return abilityMatcher != null ? abilityMatcher.group("name") : null;
    }

    @NotNull
    public static String getSkyBlockApiId(@NotNull class_9322 itemStack) {
        class_2487 customData = ItemUtils.getCustomData(itemStack);
        String id = customData.method_68564(ITEM_ID, "");
        if (customData.method_10545("is_shiny")) {
            return "SHINY_" + id;
        }
        switch (id) {
            case "ENCHANTED_BOOK": {
                if (!customData.method_10545("enchantments")) break;
                class_2487 enchants = customData.method_68568("enchantments");
                Optional firstEnchant = enchants.method_10541().stream().findFirst();
                String enchant = firstEnchant.orElse("");
                return "ENCHANTMENT_" + enchant.toUpperCase(Locale.ENGLISH) + "_" + enchants.method_68083(enchant, 0);
            }
            case "POTION": {
                String splash;
                String enhanced = customData.method_10545("enhanced") ? "_ENHANCED" : "";
                String extended = customData.method_10545("extended") ? "_EXTENDED" : "";
                String string = splash = customData.method_10545("splash") ? "_SPLASH" : "";
                if (!customData.method_10545("potion") || !customData.method_10545("potion_level")) break;
                return (customData.method_68564("potion", "") + "_" + id + "_" + customData.method_68083("potion_level", 0) + enhanced + extended + splash).toUpperCase(Locale.ENGLISH);
            }
            case "RUNE": {
                if (!customData.method_10545("runes")) break;
                class_2487 runes = customData.method_68568("runes");
                String rune = runes.method_10541().stream().findFirst().orElse("");
                return rune.toUpperCase(Locale.ENGLISH) + "_RUNE_" + runes.method_68083(rune, 0);
            }
            case "ATTRIBUTE_SHARD": {
                String name = ((class_2561)itemStack.method_58695(class_9334.field_49631, (Object)class_2561.method_43473())).getString();
                SkyBlockAttribute attribute = CaribouStonks.core().getModDataSource().getAttributeByShardName(name);
                if (attribute == null) break;
                return attribute.skyBlockApiId();
            }
            case "PET": {
                if (!customData.method_10545("petInfo")) break;
                PetInfo petInfo = PetInfo.parse(customData);
                return "LVL_1_" + String.valueOf((Object)petInfo.rarity()) + "_" + petInfo.type();
            }
            case "NEW_YEAR_CAKE": {
                return id + "_" + customData.method_68083("new_years_cake", 0);
            }
        }
        return id;
    }

    @ApiStatus.Internal
    public static String getGameType() {
        return gameType;
    }

    @ApiStatus.Internal
    public static void handleInternalUpdate() {
        FabricLoader fabricLoader = FabricLoader.getInstance();
        if ((SkyBlockAPI.CLIENT.field_1687 == null || CLIENT.method_1542()) && fabricLoader.isDevelopmentEnvironment()) {
            onSkyBlockState = true;
        }
        if (fabricLoader.isDevelopmentEnvironment() || StonksUtils.isConnectedToHypixel()) {
            if (!StonksUtils.isConnectedToHypixel()) {
                onHypixelState = true;
            }
        } else if (onHypixelState) {
            onHypixelState = false;
        }
    }

    @ApiStatus.Internal
    public static void handleInternalLocationUpdate(@Nullable Boolean onHypixel, @Nullable Boolean onSkyBlock, @Nullable String gameTypeFromServer, @Nullable IslandType islandTypeFromMode) {
        if (onHypixel != null) {
            onHypixelState = onHypixel;
        }
        if (onSkyBlock != null) {
            onSkyBlockState = onSkyBlock;
        }
        if (gameTypeFromServer != null) {
            gameType = gameTypeFromServer;
        }
        if (islandTypeFromMode != null) {
            islandType = islandTypeFromMode;
        }
        if (DeveloperTools.isInDevelopment()) {
            CaribouStonks.LOGGER.info("[SkyBlockAPI] Updated: {}, {}, {}, {}", new Object[]{onHypixelState, onSkyBlockState, gameType, islandType.name()});
        }
    }
}

