/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature;

import fr.siroz.cariboustonks.feature.Features;
import fr.siroz.cariboustonks.manager.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public abstract class Feature {
    protected static final class_310 CLIENT = class_310.method_1551();
    private final Map<Class<? extends Component>, Component> components = new HashMap<Class<? extends Component>, Component>();

    public abstract boolean isEnabled();

    protected void postInitialize(@NotNull Features features) {
    }

    protected <C extends Component> void addComponent(@NotNull Class<C> type, @NotNull C component) {
        if (this.components.containsKey(type)) {
            throw new IllegalStateException("Component of type " + type.getSimpleName() + " already registered");
        }
        this.components.put(type, component);
    }

    public <C extends Component> Optional<C> getComponent(@NotNull Class<C> type) {
        return Optional.ofNullable((Component)type.cast(this.components.get(type)));
    }

    public String getShortName() {
        return this.getClass().getSimpleName().replace("Feature", "");
    }
}

