/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.chat;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.event.ChatEvents;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.mixin.accessors.ChatHudAccessor;
import fr.siroz.cariboustonks.util.StonksUtils;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.jetbrains.annotations.Nullable;

public class CopyChatMessageFeature
extends Feature {
    public CopyChatMessageFeature() {
        ChatEvents.MESSAGE_CLICKED.register(this::onChatClick);
    }

    @Override
    public boolean isEnabled() {
        return ConfigManager.getConfig().chat.copyChat;
    }

    private void onChatClick(double mouseX, double mouseY) {
        if (!this.isEnabled()) {
            return;
        }
        long handle = class_310.method_1551().method_22683().method_4490();
        if (!class_3675.method_15987((long)handle, (int)341)) {
            return;
        }
        class_303 message = this.getMessageAt(mouseX, mouseY);
        if (message != null) {
            String toClipboard = StonksUtils.stripColor(message.comp_893().getString());
            class_310.method_1551().field_1774.method_1455(toClipboard);
        }
    }

    @Nullable
    private class_303 getMessageAt(double x, double y) {
        try {
            ChatHudAccessor accessor = (ChatHudAccessor)class_310.method_1551().field_1705.method_1743();
            int lineSelected = accessor.invokeGetMessageLineIndex(accessor.invokeToChatLineX(x), accessor.invokeToChatLineY(y));
            if (lineSelected == -1) {
                return null;
            }
            List<Integer> indexesOfEntryEnds = IntStream.range(0, accessor.getVisibleMessages().size()).filter(index -> accessor.getVisibleMessages().get(index).comp_898()).boxed().toList();
            int indexOfMessageEntryEnd = indexesOfEntryEnds.stream().filter(index -> index <= lineSelected).reduce((a, b) -> b).orElse(-1);
            if (indexOfMessageEntryEnd == -1) {
                return null;
            }
            int indexOfMessage = indexesOfEntryEnds.indexOf(indexOfMessageEntryEnd);
            return accessor.getMessages().get(indexOfMessage);
        }
        catch (Exception exception) {
            CaribouStonks.LOGGER.error("[CopyChatMessageFeature] Error to get ChatHudLine", (Throwable)exception);
            return null;
        }
    }
}

