/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.combat;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.event.NetworkEvents;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.manager.hud.Hud;
import fr.siroz.cariboustonks.manager.hud.HudProvider;
import fr.siroz.cariboustonks.manager.hud.TextHud;
import fr.siroz.cariboustonks.util.Client;
import fr.siroz.cariboustonks.util.InventoryUtils;
import fr.siroz.cariboustonks.util.ItemUtils;
import it.unimi.dsi.fastutil.Pair;
import java.text.DecimalFormat;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2767;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_9322;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class RagnarockAxeFeature
extends Feature
implements HudProvider {
    private static final class_2960 HUD_ID = CaribouStonks.identifier("hud_rag_axe");
    private static final String RAGNAROCK_AXE_ITEM_ID = "RAGNAROCK_AXE";
    private static final int RAGNAROCK_AXE_CAST_TIME = 10;
    private static final Pattern STRENGTH_PATTERN = Pattern.compile("Strength: \\+(?<strength>[\\d,.]+) *");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#0.0");
    private final Supplier<String> castMessageConfig = () -> ConfigManager.getConfig().combat.ragAxe.message;
    private Double lastStrength = null;
    private long lastCastTime = 0L;

    public RagnarockAxeFeature() {
        ClientPlayConnectionEvents.JOIN.register((_h, _s, _mc) -> this.reset());
        NetworkEvents.PLAY_SOUND_PACKET.register(this::onPlaySound);
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock() && ConfigManager.getConfig().combat.ragAxe.enabled;
    }

    @Override
    @NotNull
    public Pair<class_2960, class_2960> getAttachLayerAfter() {
        return Pair.of((Object)VanillaHudElements.STATUS_EFFECTS, (Object)HUD_ID);
    }

    @Override
    @NotNull
    public Hud getHud() {
        return new TextHud((class_2561)class_2561.method_43470((String)"\u00a7cRag Casted! \u00a7e8.4s \u00a7f(\u00a7c+765.1\u00a7f)"), this::getText, ConfigManager.getConfig().combat.ragAxe.hud, 200, 10);
    }

    @Contract(pure=true)
    @NotNull
    private class_2561 getText() {
        if (this.lastStrength == null || this.lastCastTime == 0L) {
            return class_2561.method_43473();
        }
        long currentTime = System.currentTimeMillis();
        double timeRemaining = (double)(this.lastCastTime - currentTime) / 1000.0;
        if (timeRemaining > 0.0) {
            String strength = this.lastStrength == 0.0 ? "?" : DECIMAL_FORMAT.format(this.lastStrength);
            return class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)this.castMessageConfig.get())).method_10852((class_2561)class_2561.method_43470((String)(" " + DECIMAL_FORMAT.format(timeRemaining) + "s")).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)("+" + strength)).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1080));
        }
        this.reset();
        return class_2561.method_43473();
    }

    private void onPlaySound(class_2767 packet) {
        if (!this.isEnabled()) {
            return;
        }
        if (packet.method_11892() != 1.4920635f) {
            return;
        }
        if (packet.method_11894() == null || packet.method_11894().comp_349() == null) {
            return;
        }
        if (!((class_3414)packet.method_11894().comp_349()).comp_3319().method_12832().startsWith("entity.wolf.death")) {
            return;
        }
        class_1799 held = InventoryUtils.getHeldItem();
        if (held == null || held.method_7960()) {
            return;
        }
        if (SkyBlockAPI.getSkyBlockItemId((class_9322)held).equals(RAGNAROCK_AXE_ITEM_ID)) {
            double strength = this.getStrength(held);
            this.lastStrength = strength > 0.0 ? strength * 1.5 : 0.0;
            this.lastCastTime = System.currentTimeMillis() + 10000L;
            Client.showTitle((class_2561)class_2561.method_43470((String)this.castMessageConfig.get()), 1, 20, 1);
        }
    }

    private void reset() {
        this.lastStrength = null;
        this.lastCastTime = 0L;
    }

    private double getStrength(class_1799 item) {
        try {
            for (class_2561 line : ItemUtils.getLore(item)) {
                Matcher strengthMatcher = STRENGTH_PATTERN.matcher(line.getString());
                if (!strengthMatcher.find()) continue;
                return Double.parseDouble(strengthMatcher.group("strength"));
            }
            return -1.0;
        }
        catch (Exception ignored) {
            return -1.0;
        }
    }
}

