/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.combat;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.scheduler.TickScheduler;
import fr.siroz.cariboustonks.core.skyblock.IslandType;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.event.ChatEvents;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.manager.hud.Hud;
import fr.siroz.cariboustonks.manager.hud.HudProvider;
import fr.siroz.cariboustonks.manager.hud.MultiElementHud;
import fr.siroz.cariboustonks.manager.hud.builder.HudElementBuilder;
import fr.siroz.cariboustonks.manager.hud.builder.HudElementTextBuilder;
import fr.siroz.cariboustonks.manager.hud.element.HudElement;
import fr.siroz.cariboustonks.util.Client;
import fr.siroz.cariboustonks.util.StonksUtils;
import it.unimi.dsi.fastutil.Pair;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import org.jetbrains.annotations.NotNull;

public class SecondLifeFeature
extends Feature
implements HudProvider {
    private static final class_2960 HUD_ID = CaribouStonks.identifier("hud_second_life");
    private static final Pattern SPIRIT_MASK_PATTERN = Pattern.compile("Second Wind Activated! Your Spirit Mask saved your life!");
    private static final Pattern BONZO_MASK_PATTERN = Pattern.compile("Your Bonzo's Mask saved your life!");
    private static final Pattern PHOENIX_PET_PATTERN = Pattern.compile("Your Phoenix Pet saved you from certain death!");
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("");
    private static final DecimalFormat TIME_FORMAT = new DecimalFormat("#0.0");
    private final Map<SecondLife, Long> activeCooldowns = new HashMap<SecondLife, Long>();
    private boolean serverHasChanged = false;
    private final HudElementBuilder hudBuilder;
    private final Hud hud;

    public SecondLifeFeature() {
        ChatEvents.MESSAGE_RECEIVED.register(this::onChatMessage);
        ClientPlayConnectionEvents.JOIN.register((_handler, _sender, _mc) -> this.reset());
        this.hudBuilder = new HudElementBuilder();
        this.hud = new MultiElementHud(() -> this.isEnabled() && !this.activeCooldowns.isEmpty(), new HudElementTextBuilder().append((class_2561)class_2561.method_43470((String)"Spirit Mask: 42.9s").method_27692(class_124.field_1064)).append((class_2561)class_2561.method_43470((String)"Phoenix: 51.7s").method_27692(class_124.field_1054)).build(), this::getHudLines, ConfigManager.getConfig().combat.secondLife.cooldownHud, 150, 50);
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock();
    }

    @Override
    @NotNull
    public Pair<class_2960, class_2960> getAttachLayerAfter() {
        return Pair.of((Object)VanillaHudElements.STATUS_EFFECTS, (Object)HUD_ID);
    }

    @Override
    @NotNull
    public Hud getHud() {
        return this.hud;
    }

    private void onChatMessage(@NotNull class_2561 text) {
        if (!this.isEnabled()) {
            return;
        }
        String message = StonksUtils.stripColor(text.getString());
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(message);
        if (ConfigManager.getConfig().combat.secondLife.spiritMaskUsed && matcher.usePattern(SPIRIT_MASK_PATTERN).matches()) {
            this.onSecondLife(SecondLife.SPIRIT_MASK);
            return;
        }
        if (ConfigManager.getConfig().combat.secondLife.phoenixUsed && matcher.usePattern(PHOENIX_PET_PATTERN).matches()) {
            this.onSecondLife(SecondLife.PHOENIX_PET);
            return;
        }
        if (SkyBlockAPI.getIsland() == IslandType.DUNGEON && ConfigManager.getConfig().combat.secondLife.bonzoMaskUsed && matcher.usePattern(BONZO_MASK_PATTERN).matches()) {
            this.onSecondLife(SecondLife.BONZO_MASK);
        }
    }

    private void onSecondLife(@NotNull SecondLife secondLife) {
        this.serverHasChanged = false;
        Client.showTitle((class_2561)class_2561.method_43470((String)(secondLife.getName() + " used!")).method_27692(class_124.field_1061), 0, 30, 0);
        long cooldownEndTime = System.currentTimeMillis() + (long)secondLife.getCooldown() * 1000L;
        this.activeCooldowns.put(secondLife, cooldownEndTime);
        TickScheduler.getInstance().runLater(() -> this.onSecondLifeBack(secondLife), secondLife.getCooldown(), TimeUnit.SECONDS);
    }

    private void onSecondLifeBack(@NotNull SecondLife secondLife) {
        this.activeCooldowns.remove((Object)secondLife);
        if (!this.serverHasChanged && secondLife.isBackConfigEnabled()) {
            Client.sendMessageWithPrefix((class_2561)class_2561.method_43470((String)(secondLife.getName() + " is back!")).method_27692(class_124.field_1060));
            Client.showTitle((class_2561)class_2561.method_43470((String)(secondLife.getName() + " ready!")).method_27692(class_124.field_1060), 0, 30, 0);
            Client.playSound(class_3417.field_14627, 1.0f, 1.0f);
        }
    }

    private List<? extends HudElement> getHudLines() {
        this.hudBuilder.clear();
        if (this.activeCooldowns.isEmpty()) {
            return this.hudBuilder.build();
        }
        try {
            long currentTime = System.currentTimeMillis();
            this.activeCooldowns.entrySet().removeIf(entry -> (Long)entry.getValue() <= currentTime);
            List sortedCooldowns = this.activeCooldowns.entrySet().stream().sorted(Map.Entry.comparingByValue()).toList();
            for (Map.Entry entry2 : sortedCooldowns) {
                double timeRemaining = (double)((Long)entry2.getValue() - currentTime) / 1000.0;
                if (!(timeRemaining > 0.0)) continue;
                SecondLife secondLife = (SecondLife)((Object)entry2.getKey());
                String formattedTime = TIME_FORMAT.format(timeRemaining);
                this.hudBuilder.appendLine((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)secondLife.getName()).method_27692(secondLife.getColor())).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)(formattedTime + "s")).method_27692(this.getColor(timeRemaining))));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.hudBuilder.build();
    }

    private class_124 getColor(double timeRemaining) {
        if (timeRemaining <= 10.0) {
            return class_124.field_1060;
        }
        if (timeRemaining <= 30.0) {
            return class_124.field_1065;
        }
        return class_124.field_1061;
    }

    private void reset() {
        this.serverHasChanged = true;
        this.activeCooldowns.clear();
    }

    private static enum SecondLife {
        SPIRIT_MASK(30, "Spirit Mask", class_124.field_1064, () -> ConfigManager.getConfig().combat.secondLife.spiritMaskBack),
        BONZO_MASK(180, "Bonzo Mask", class_124.field_1061, () -> ConfigManager.getConfig().combat.secondLife.bonzoMaskBack),
        PHOENIX_PET(60, "Phoenix Pet", class_124.field_1054, () -> ConfigManager.getConfig().combat.secondLife.phoenixBack);

        private final int cooldown;
        private final String name;
        private final class_124 color;
        private final BooleanSupplier backConfig;

        private SecondLife(int cooldown, String name, class_124 color, BooleanSupplier backConfig) {
            this.cooldown = cooldown;
            this.name = name;
            this.color = color;
            this.backConfig = backConfig;
        }

        public int getCooldown() {
            return this.cooldown;
        }

        public String getName() {
            return this.name;
        }

        public class_124 getColor() {
            return this.color;
        }

        public boolean isBackConfigEnabled() {
            return this.backConfig.getAsBoolean();
        }
    }
}

