/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.fishing;

import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.event.NetworkEvents;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.feature.Features;
import fr.siroz.cariboustonks.feature.fishing.RareSeaCreatureFeature;
import fr.siroz.cariboustonks.util.Client;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_1531;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BobberTimerFeature
extends Feature {
    private static final Pattern TIMER_PATTERN = Pattern.compile("\\d.\\d");
    private static final double MIN_BOBBER_TIMER_DISTANCE = 0.1;
    @Nullable
    private RareSeaCreatureFeature rareSeaCreatureFeature;
    @Nullable
    private class_1531 bobberTimerArmorStand;

    public BobberTimerFeature() {
        ClientPlayConnectionEvents.JOIN.register((_handler, _sender, _client) -> {
            this.bobberTimerArmorStand = null;
        });
        NetworkEvents.ARMORSTAND_UPDATE_PACKET.register(this::onArmorStandUpdate);
        ClientTickEvents.END_CLIENT_TICK.register(_client -> this.update());
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock() && ConfigManager.getConfig().fishing.bobberTimerDisplay;
    }

    @Override
    protected void postInitialize(@NotNull Features features) {
        this.rareSeaCreatureFeature = features.getFeature(RareSeaCreatureFeature.class);
    }

    private void onArmorStandUpdate(@NotNull class_1531 armorStand, boolean equipment) {
        if (equipment || !armorStand.method_16914() || armorStand.method_5477() == null) {
            return;
        }
        if (BobberTimerFeature.CLIENT.field_1724 == null || BobberTimerFeature.CLIENT.field_1724.field_7513 == null) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.bobberTimerArmorStand != null) {
            return;
        }
        if (armorStand.method_19538().method_1022(BobberTimerFeature.CLIENT.field_1724.field_7513.method_19538()) > 0.1) {
            return;
        }
        Matcher timerMatcher = TIMER_PATTERN.matcher(armorStand.method_5477().getString());
        this.bobberTimerArmorStand = timerMatcher.matches() ? armorStand : null;
    }

    private void update() {
        if (this.bobberTimerArmorStand == null || !this.bobberTimerArmorStand.method_5805() || !this.bobberTimerArmorStand.method_16914()) {
            this.bobberTimerArmorStand = null;
            return;
        }
        if (BobberTimerFeature.CLIENT.field_1724 == null || BobberTimerFeature.CLIENT.field_1724.field_7513 == null || this.bobberTimerArmorStand == null) {
            return;
        }
        class_2561 bobberTimerText = this.bobberTimerArmorStand.method_5797();
        if (this.isEnabled() && bobberTimerText != null && (this.rareSeaCreatureFeature == null || !this.rareSeaCreatureFeature.hasFoundCreature())) {
            Client.showSubtitle(bobberTimerText, 0, 25, 1);
        }
    }
}

