/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.fishing;

import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.scheduler.TickScheduler;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.event.ChatEvents;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.feature.fishing.RareSeaCreature;
import fr.siroz.cariboustonks.util.Client;
import fr.siroz.cariboustonks.util.InventoryUtils;
import fr.siroz.cariboustonks.util.StonksUtils;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class RareSeaCreatureFeature
extends Feature {
    private static final Pattern DOUBLE_HOOK_PATTERN = Pattern.compile("Double Hook!(?: Woot woot!)?");
    private boolean foundCreature = false;
    private boolean doubleHook = false;

    public RareSeaCreatureFeature() {
        ClientPlayConnectionEvents.JOIN.register((_handler, _ps, _client) -> this.reset());
        ChatEvents.MESSAGE_RECEIVED.register(this::onChatMessage);
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock() && ConfigManager.getConfig().fishing.rareSeaCreatureWarning;
    }

    public boolean hasFoundCreature() {
        return this.foundCreature;
    }

    private void onChatMessage(@NotNull class_2561 text) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.hasFishingRod()) {
            return;
        }
        String message = StonksUtils.stripColor(text.getString());
        if (DOUBLE_HOOK_PATTERN.matcher(message).find()) {
            this.doubleHook = true;
            return;
        }
        RareSeaCreature seaCreature = RareSeaCreature.fromChatMessage(message);
        if (seaCreature != null && !this.foundCreature) {
            this.foundCreature = true;
            this.showNotification(seaCreature, this.doubleHook);
            TickScheduler.getInstance().runLater(() -> {
                this.foundCreature = false;
            }, 5, TimeUnit.SECONDS);
        }
        this.doubleHook = false;
    }

    private void showNotification(@NotNull RareSeaCreature seaCreature, boolean doubleHook) {
        class_5250 seaCreatureText = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"[iL ").method_27695(new class_124[]{seaCreature.getColor(), class_124.field_1051})).method_10852(seaCreature.getText()).method_10852((class_2561)class_2561.method_43470((String)" Li]").method_27695(new class_124[]{seaCreature.getColor(), class_124.field_1051}));
        class_5250 doubleHookText = doubleHook ? class_2561.method_43470((String)"Double Hook").method_27692(class_124.field_1060) : class_2561.method_43473();
        Client.showTitleAndSubtitle((class_2561)seaCreatureText, (class_2561)doubleHookText, 0, 40, 5);
        if (ConfigManager.getConfig().fishing.rareSeaCreatureSound) {
            if (doubleHook) {
                Client.playSound(class_3417.field_14671, 2.5f, 1.0f);
            } else {
                Client.playSound((class_3414)class_3417.field_21866.comp_349(), 2.5f, 1.0f);
            }
        }
    }

    private boolean hasFishingRod() {
        class_1799 item = InventoryUtils.getHeldItem();
        return item != null && !item.method_7960() && item.method_31574(class_1802.field_8378);
    }

    private void reset() {
        this.doubleHook = false;
        this.foundCreature = false;
    }
}

