/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.garden.pest;

import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.skyblock.IslandType;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.event.HudEvents;
import fr.siroz.cariboustonks.event.InteractionEvents;
import fr.siroz.cariboustonks.event.NetworkEvents;
import fr.siroz.cariboustonks.event.WorldEvents;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.feature.garden.pest.PestFinderRenderer;
import fr.siroz.cariboustonks.feature.garden.pest.PlotInfestedRenderer;
import fr.siroz.cariboustonks.util.math.bezier.ParticlePathPredictor;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2675;
import net.minecraft.class_9322;
import org.jetbrains.annotations.NotNull;

public final class PestFinderFeature
extends Feature {
    private static final Pattern INFESTED_PLOTS_TABLIST_PATTERN = Pattern.compile("\\sPlots: (?<plots>.*)");
    private final PestFinderRenderer pestFinderRenderer;
    private final PlotInfestedRenderer plotInfestedRenderer;
    private final ParticlePathPredictor predictor = new ParticlePathPredictor(3);
    private final List<Integer> infestedPlots = new ArrayList<Integer>();
    private long lastUsedVacuum = 0L;
    private class_243 guessPosition = null;

    public PestFinderFeature() {
        this.pestFinderRenderer = new PestFinderRenderer(this);
        this.plotInfestedRenderer = new PlotInfestedRenderer(this);
        WorldEvents.JOIN.register(world -> this.reset());
        InteractionEvents.LEFT_CLICK_AIR.register(this::onLeftClickAir);
        NetworkEvents.PARTICLE_RECEIVED_PACKET.register(this::onParticleReceived);
        HudEvents.TAB_LIST_UPDATE.register(this::onTabListUpdate);
        WorldRenderEvents.AFTER_TRANSLUCENT.register(this::render);
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock() && SkyBlockAPI.getIsland() == IslandType.GARDEN && ConfigManager.getConfig().farming.garden.pestsLocator;
    }

    public class_243 getGuessPosition() {
        return this.guessPosition;
    }

    public boolean highlightInfestedPlots() {
        return ConfigManager.getConfig().farming.garden.highlightInfestedPlots;
    }

    public List<Integer> getInfestedPlots() {
        return this.infestedPlots;
    }

    private void reset() {
        this.infestedPlots.clear();
        this.predictor.reset();
        this.guessPosition = null;
        this.lastUsedVacuum = 0L;
    }

    private void onLeftClickAir(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!this.isEnabled() || stack == null || stack.method_7960()) {
            return;
        }
        if (SkyBlockAPI.getSkyBlockItemId((class_9322)stack).contains("VACUUM")) {
            this.predictor.reset();
            this.guessPosition = null;
            this.lastUsedVacuum = System.currentTimeMillis();
        }
    }

    private void onParticleReceived(class_2675 packet) {
        if (!this.isEnabled()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastUsedVacuum > 5000L) {
            return;
        }
        if (class_2398.field_11231.equals(packet.method_11551().method_10295())) {
            class_243 pos = new class_243(packet.method_11544(), packet.method_11547(), packet.method_11546());
            this.handleParticle(pos);
        }
    }

    private void handleParticle(class_243 position) {
        if (this.predictor.isEmpty()) {
            this.predictor.addPoint(position);
            return;
        }
        class_243 lastPoint = this.predictor.getLastPoint();
        if (lastPoint == null) {
            return;
        }
        double dist = lastPoint.method_1022(position);
        if (dist == 0.0 || dist > 3.0) {
            return;
        }
        this.predictor.addPoint(position);
        class_243 solved = this.predictor.solve();
        if (solved == null) {
            return;
        }
        this.guessPosition = solved;
    }

    private void onTabListUpdate(@NotNull List<String> lines) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.highlightInfestedPlots()) {
            return;
        }
        this.infestedPlots.clear();
        for (String line : lines) {
            Matcher matcher = INFESTED_PLOTS_TABLIST_PATTERN.matcher(line);
            if (!matcher.find()) continue;
            for (String plot : matcher.group("plots").split(", ")) {
                if (plot.isEmpty()) continue;
                try {
                    int plotId = Integer.parseInt(plot);
                    this.infestedPlots.add(plotId);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private void render(WorldRenderContext context) {
        this.pestFinderRenderer.render(context);
        this.plotInfestedRenderer.render(context);
    }
}

