/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.keyshortcut;

import com.google.common.reflect.TypeToken;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.core.json.JsonProcessingException;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.feature.keyshortcut.KeyShortcut;
import fr.siroz.cariboustonks.manager.command.CommandComponent;
import fr.siroz.cariboustonks.screen.keyshortcut.KeyShortcutScreen;
import fr.siroz.cariboustonks.util.StonksUtils;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;

public class KeyShortcutFeature
extends Feature {
    private static final Path SHORTCUTS_PATH = CaribouStonks.CONFIG_DIR.resolve("shortcuts.json");
    private static final long COOLDOWN = 500L;
    private final Map<String, KeyShortcut> shortcuts = new ConcurrentHashMap<String, KeyShortcut>();
    private long lastKeyPressed = 0L;

    public KeyShortcutFeature() {
        ClientLifecycleEvents.CLIENT_STARTED.register(this::onClientStarted);
        ClientLifecycleEvents.CLIENT_STOPPING.register(this::saveShortcuts);
        ClientTickEvents.END_CLIENT_TICK.register(this::onTick);
        this.addComponent(CommandComponent.class, d -> d.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cariboustonks").then(ClientCommandManager.literal((String)"keyShortcuts").executes(StonksUtils.openScreen(() -> KeyShortcutScreen.create(null))))));
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock();
    }

    public Map<String, KeyShortcut> getShortcutsCopy() {
        return Map.copyOf(this.shortcuts);
    }

    public void updateShortcuts(@NotNull Map<String, KeyShortcut> newShortcuts) {
        this.shortcuts.clear();
        this.shortcuts.putAll(newShortcuts);
    }

    public void saveShortcuts(class_310 client) {
        HashMap<String, Integer> shortcutsToSave = new HashMap<String, Integer>();
        for (Map.Entry<String, KeyShortcut> entry : this.shortcuts.entrySet()) {
            shortcutsToSave.put(entry.getKey(), entry.getValue().keyCode());
        }
        try {
            CaribouStonks.core().getJsonFileService().save(SHORTCUTS_PATH, shortcutsToSave);
        }
        catch (JsonProcessingException ex) {
            CaribouStonks.LOGGER.error("[KeyShortcuts] Unable to save shortcuts", (Throwable)ex);
        }
    }

    private void onClientStarted(class_310 client) {
        this.loadKeyShortcuts().thenAccept(this::loadExistingKeyShortcuts);
    }

    private CompletableFuture<Map<String, Integer>> loadKeyShortcuts() {
        if (!Files.exists(SHORTCUTS_PATH, new LinkOption[0])) {
            return CompletableFuture.completedFuture(Map.of());
        }
        return CompletableFuture.supplyAsync(() -> {
            Type mapType = new TypeToken<Map<String, Integer>>(){}.getType();
            try {
                return CaribouStonks.core().getJsonFileService().loadMap(SHORTCUTS_PATH, mapType);
            }
            catch (JsonProcessingException ex) {
                CaribouStonks.LOGGER.error("[KeyShortcuts] Unable to load shortcuts", (Throwable)ex);
                return Collections.emptyMap();
            }
        });
    }

    private void loadExistingKeyShortcuts(@NotNull Map<String, Integer> shortcutsMap) {
        int loaded = 0;
        for (Map.Entry<String, Integer> entry : shortcutsMap.entrySet()) {
            if (entry.getKey() == null || entry.getKey().isBlank()) continue;
            this.shortcuts.put(entry.getKey(), new KeyShortcut(entry.getKey(), entry.getValue()));
            ++loaded;
        }
        CaribouStonks.LOGGER.info("[KeyShortcuts] Loaded {} KeyShortcut", (Object)loaded);
    }

    private void onTick(class_310 client) {
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        if (client.field_1755 != null) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (System.currentTimeMillis() - this.lastKeyPressed < 500L) {
            return;
        }
        long handle = client.method_22683().method_4490();
        for (KeyShortcut shortcut : this.shortcuts.values()) {
            int mouseButton;
            boolean pressed;
            if (shortcut.command().isBlank() || shortcut.keyCode() == -1 || !(pressed = shortcut.keyCode() <= -2000 ? GLFW.glfwGetMouseButton((long)handle, (int)(mouseButton = -2000 - shortcut.keyCode())) == 1 : class_3675.method_15987((long)handle, (int)shortcut.keyCode()))) continue;
            this.lastKeyPressed = System.currentTimeMillis();
            this.handleShortcut(client, shortcut);
        }
    }

    private void handleShortcut(@NotNull class_310 client, @NotNull KeyShortcut shortcut) {
        if (client.field_1724 != null && client.field_1724.field_3944 != null) {
            String shortcutCommand = shortcut.command();
            String command = shortcutCommand.startsWith("/") ? shortcutCommand.substring(1) : shortcutCommand;
            client.field_1724.field_3944.method_45730(command);
        }
    }
}

