/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.misc;

import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.util.Calculator;
import fr.siroz.cariboustonks.util.StonksUtils;
import fr.siroz.cariboustonks.util.colors.Colors;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.config.SearchFieldLocation;
import me.shedaniel.rei.api.client.gui.widgets.TextField;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class REISearchBarCalculatorFeature
extends Feature {
    private String lastSearchBarInput = "";
    private String lastCalculatorResult = null;

    public REISearchBarCalculatorFeature() {
        ScreenEvents.BEFORE_INIT.register(this::onScreenBeforeInit);
    }

    @Override
    public boolean isEnabled() {
        return ConfigManager.getConfig().misc.compatibility.reiSearchBarCalculator && FabricLoader.getInstance().isModLoaded("roughlyenoughitems");
    }

    private void onScreenBeforeInit(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
        if (this.isEnabled() && screen instanceof class_465) {
            class_465 handledScreen = (class_465)screen;
            ScreenEvents.afterRender((class_437)screen).register((_screen, context, mouseX, mouseY, tickDelta) -> {
                TextField searchBarField = REIRuntime.getInstance().getSearchTextField();
                if (searchBarField == null) {
                    return;
                }
                String searchBarText = searchBarField.getText();
                if (searchBarText.isBlank() || !searchBarText.matches(".*\\d.*")) {
                    return;
                }
                class_2561 calculatorTextResult = this.getCalculatorTextResult(searchBarText);
                if (calculatorTextResult.getString().contains("=")) {
                    this.draw(context, handledScreen, calculatorTextResult);
                }
            });
        }
    }

    @NotNull
    private class_2561 getCalculatorTextResult(String searchBarFieldText) {
        String result = this.calculate(searchBarFieldText);
        return result == null ? class_2561.method_43473() : class_2561.method_43470((String)searchBarFieldText).method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)" = ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)result).method_27692(class_124.field_1060));
    }

    @Nullable
    private String calculate(String searchBarInput) {
        if (!this.lastSearchBarInput.equals(searchBarInput)) {
            this.lastSearchBarInput = searchBarInput;
            try {
                double result = Calculator.calculate(searchBarInput);
                this.lastCalculatorResult = StonksUtils.DOUBLE_NUMBERS.format(result);
            }
            catch (Throwable ignored) {
                this.lastCalculatorResult = null;
            }
        }
        return this.lastCalculatorResult;
    }

    private void draw(@NotNull class_332 context, @NotNull class_465<?> handledScreen, class_2561 displayText) {
        int x = REIRuntime.getInstance().getContextualSearchFieldLocation() == SearchFieldLocation.BOTTOM_SIDE ? handledScreen.field_22789 / 2 + 90 : handledScreen.field_22789 / 2 - 80;
        int y = handledScreen.field_22790 - 32;
        context.method_51439(class_310.method_1551().field_1772, displayText, x, y, Colors.WHITE.asInt(), false);
    }
}

