/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.slayer;

import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.event.SkyBlockEvents;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.feature.slayer.SlayerBossRun;
import fr.siroz.cariboustonks.manager.slayer.SlayerTier;
import fr.siroz.cariboustonks.manager.slayer.SlayerType;
import fr.siroz.cariboustonks.util.Client;
import fr.siroz.cariboustonks.util.StonksUtils;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.DoubleSummaryStatistics;
import java.util.LongSummaryStatistics;
import java.util.Objects;
import java.util.OptionalDouble;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class SlayerStatsFeature
extends Feature {
    private static final int MAX_RUNS_STORED = 25;
    private final Deque<SlayerBossRun> runs = new ArrayDeque<SlayerBossRun>();
    private SlayerBossRun currentRun = null;

    public SlayerStatsFeature() {
        SkyBlockEvents.SLAYER_BOSS_SPAWN.register(this::onBossSpawn);
        SkyBlockEvents.SLAYER_MINIBOSS_SPAWN.register(this::onMinibossSpawn);
        SkyBlockEvents.SLAYER_QUEST_START.register(this::onQuestStart);
        SkyBlockEvents.SLAYER_QUEST_FAIL.register((_type, _tier) -> {
            this.currentRun = null;
        });
        SkyBlockEvents.SLAYER_BOSS_DEATH.register(this::onBossDeath);
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock();
    }

    private void onBossSpawn(@NotNull SlayerType type, @NotNull SlayerTier tier) {
        if (ConfigManager.getConfig().slayer.bossSpawnAlert) {
            Client.showTitle((class_2561)class_2561.method_43470((String)"Boss spawned!").method_27692(class_124.field_1079), 1, 20, 1);
        }
    }

    private void onMinibossSpawn(@NotNull SlayerType type, @NotNull SlayerTier tier) {
        if (ConfigManager.getConfig().slayer.minibossSpawnAlert) {
            Client.showTitle((class_2561)class_2561.method_43470((String)"Miniboss spawned!").method_27692(class_124.field_1061), 1, 20, 1);
        }
    }

    private void onQuestStart(@NotNull SlayerType type, @NotNull SlayerTier tier, boolean afterUpdate) {
        if (!ConfigManager.getConfig().slayer.showStatsBreakdown) {
            return;
        }
        if (!this.runs.isEmpty() && afterUpdate && (this.runs.getFirst().getSlayerType() != type || this.runs.getFirst().getSlayerTier() != tier)) {
            this.runs.clear();
        }
        if (afterUpdate && this.currentRun != null) {
            this.currentRun.setSlayerType(type);
            this.currentRun.setSlayerTier(tier);
        } else {
            this.currentRun = new SlayerBossRun(type, tier);
            this.currentRun.setQuestStart(Instant.now());
        }
    }

    private void onBossDeath(@NotNull SlayerType type, @NotNull SlayerTier tier, @Nullable Instant startTime) {
        if (!ConfigManager.getConfig().slayer.showStatsBreakdown) {
            return;
        }
        if (this.currentRun != null && type != SlayerType.UNKNOWN && tier != SlayerTier.UNKNOWN) {
            this.currentRun.setBossSpawn(startTime);
            this.currentRun.setBossKill(Instant.now());
            this.currentRun.setExpReward(Double.valueOf(type.getExpPerTier()[tier.ordinal() - 1]));
            this.finalizeRun(this.currentRun);
            this.showBreakdown(this.currentRun);
            if (ConfigManager.getConfig().slayer.showStatsInChat) {
                this.showStats();
            }
            this.currentRun = null;
        }
    }

    private void finalizeRun(SlayerBossRun run) {
        if (this.runs.size() >= 25) {
            this.runs.removeFirst();
        }
        this.runs.addLast(run);
    }

    private void showBreakdown(@NotNull SlayerBossRun currentRun) {
        class_5250 message = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"BREAKDOWN ").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Spawn: ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)this.simpleFormatMillis(currentRun.timeToSpawn().toMillis())).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" Kill: ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)this.simpleFormatMillis(currentRun.timeToKill().toMillis())).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" (Total: ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)this.simpleFormatMillis(currentRun.cycleDuration().toMillis())).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1080));
        Client.sendMessage((class_2561)message);
    }

    private void showStats() {
        OptionalDouble avgSpawn = this.averageSecondsToSpawn();
        OptionalDouble avgKill = this.averageSecondsToKill();
        OptionalDouble bph = this.bossesPerHour();
        OptionalDouble xph = this.expPerHour();
        String textSpawnAvg = avgSpawn.isPresent() ? this.formatDurationSeconds(Math.round(avgSpawn.getAsDouble())) : "N/A";
        String textKillAvg = avgKill.isPresent() ? this.formatDurationSeconds(Math.round(avgKill.getAsDouble())) : "N/A";
        String textBossPerHour = bph.isPresent() ? String.format("%.2f", bph.getAsDouble()) : "N/A";
        String textExpPerHour = xph.isPresent() ? StonksUtils.SHORT_FLOAT_NUMBERS.format(xph.getAsDouble()) : "N/A";
        class_5250 message = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"STATS ").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Spawn Avg: ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)textSpawnAvg).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" Kill Avg: ").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)textKillAvg).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" Boss/h: ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)textBossPerHour).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" EXP/h: ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)textExpPerHour).method_27692(class_124.field_1054));
        Client.sendMessage((class_2561)message);
    }

    public OptionalDouble averageSecondsToSpawn() {
        LongSummaryStatistics stats = this.runs.stream().map(SlayerBossRun::timeToSpawn).filter(Objects::nonNull).mapToLong(Duration::getSeconds).summaryStatistics();
        return stats.getCount() >= 2L ? OptionalDouble.of(stats.getAverage()) : OptionalDouble.empty();
    }

    public OptionalDouble averageSecondsToKill() {
        LongSummaryStatistics stats = this.runs.stream().map(SlayerBossRun::timeToKill).filter(Objects::nonNull).mapToLong(Duration::getSeconds).summaryStatistics();
        return stats.getCount() >= 2L ? OptionalDouble.of(stats.getAverage()) : OptionalDouble.empty();
    }

    public OptionalDouble averageCycleSeconds() {
        LongSummaryStatistics stats = this.runs.stream().map(SlayerBossRun::cycleDuration).filter(Objects::nonNull).mapToLong(Duration::getSeconds).summaryStatistics();
        return stats.getCount() >= 2L ? OptionalDouble.of(stats.getAverage()) : OptionalDouble.empty();
    }

    public OptionalDouble averageExpPerBoss() {
        DoubleSummaryStatistics stats = this.runs.stream().mapToDouble(SlayerBossRun::getExpReward).summaryStatistics();
        return stats.getCount() >= 2L ? OptionalDouble.of(stats.getAverage()) : OptionalDouble.empty();
    }

    public OptionalDouble bossesPerHour() {
        OptionalDouble acs = this.averageCycleSeconds();
        if (acs.isPresent() && acs.getAsDouble() > 0.0) {
            return OptionalDouble.of(3600.0 / acs.getAsDouble());
        }
        return OptionalDouble.empty();
    }

    public OptionalDouble expPerHour() {
        OptionalDouble bph = this.bossesPerHour();
        OptionalDouble aEpb = this.averageExpPerBoss();
        if (bph.isPresent() && aEpb.isPresent()) {
            return OptionalDouble.of(bph.getAsDouble() * aEpb.getAsDouble());
        }
        return OptionalDouble.empty();
    }

    private String simpleFormatMillis(long millis) {
        return String.format("%.2fs", (double)millis / 1000.0);
    }

    private String formatDurationSeconds(long seconds) {
        long s = seconds % 60L;
        long m = seconds / 60L % 60L;
        long h = seconds / 3600L;
        if (h > 0L) {
            return String.format("%dh %02dm %02ds", h, m, s);
        }
        if (m > 0L) {
            return String.format("%dm %02ds", m, s);
        }
        return String.format("%ds", s);
    }
}

