/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.slayer.boss;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.event.NetworkEvents;
import fr.siroz.cariboustonks.event.SkyBlockEvents;
import fr.siroz.cariboustonks.event.WorldEvents;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.manager.glowing.EntityGlowProvider;
import fr.siroz.cariboustonks.manager.slayer.SlayerManager;
import fr.siroz.cariboustonks.manager.slayer.SlayerTier;
import fr.siroz.cariboustonks.manager.slayer.SlayerType;
import fr.siroz.cariboustonks.util.ItemUtils;
import fr.siroz.cariboustonks.util.colors.Colors;
import fr.siroz.cariboustonks.util.render.WorldRenderUtils;
import fr.siroz.cariboustonks.util.render.WorldRendererProvider;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientWorldEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1531;
import org.jetbrains.annotations.NotNull;

public class TarantulaBossFeature
extends Feature
implements WorldRendererProvider,
EntityGlowProvider {
    private static final Pattern COCOON_EGG_PATTERN = Pattern.compile("(\\d+)s (\\d)/3");
    private final SlayerManager slayerManager;
    private final Set<class_1531> bossEggs = new HashSet<class_1531>();

    public TarantulaBossFeature() {
        this.slayerManager = CaribouStonks.managers().getManager(SlayerManager.class);
        ClientWorldEvents.AFTER_CLIENT_WORLD_CHANGE.register((_mc, _world) -> this.bossEggs.clear());
        SkyBlockEvents.SLAYER_BOSS_DEATH.register((_type, _tier, _startTime) -> this.bossEggs.clear());
        WorldRenderEvents.AFTER_TRANSLUCENT.register(this::render);
        NetworkEvents.ARMORSTAND_UPDATE_PACKET.register(this::onArmorStandUpdate);
        WorldEvents.ARMORSTAND_REMOVED.register(this::onRemoveArmorStand);
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock() && ConfigManager.getConfig().slayer.tarantulaBoss.highlightBossEggs && this.slayerManager.isInQuestWithBoss(SlayerType.SPIDER) && this.slayerManager.isSlayerTier(SlayerTier.V);
    }

    @Override
    public void render(WorldRenderContext context) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.bossEggs.isEmpty()) {
            return;
        }
        if (!ConfigManager.getConfig().slayer.tarantulaBoss.showCursorLineToBossEggs) {
            return;
        }
        for (class_1531 egg : this.bossEggs) {
            WorldRenderUtils.renderLineFromCursor(context, egg.method_19538(), Colors.PURPLE, 1.2f);
        }
    }

    @Override
    public int getEntityGlowColor(@NotNull class_1297 entity) {
        class_1531 armorStand;
        if (entity instanceof class_1531 && this.isTarantulaBossEgg(armorStand = (class_1531)entity)) {
            return ConfigManager.getConfig().slayer.tarantulaBoss.highlightBossEggsColor.getRGB();
        }
        return 0;
    }

    private void onArmorStandUpdate(@NotNull class_1531 armorStand, boolean equipment) {
        class_1297 bossEntity;
        Matcher cocoonEggMatcher;
        if (this.isEnabled() && !equipment && (cocoonEggMatcher = COCOON_EGG_PATTERN.matcher(armorStand.method_5477().getString())).matches() && (bossEntity = this.slayerManager.getBossEntity()) != null && armorStand.method_19538().method_1022(bossEntity.method_19538()) <= 15.0) {
            this.bossEggs.add(armorStand);
        }
    }

    private void onRemoveArmorStand(@NotNull class_1531 armorStand) {
        if (this.isEnabled() && !this.bossEggs.isEmpty()) {
            Iterator<class_1531> iterator = this.bossEggs.iterator();
            while (iterator.hasNext()) {
                class_1531 egg = iterator.next();
                if (egg.method_5628() != armorStand.method_5628()) continue;
                iterator.remove();
                break;
            }
        }
    }

    private boolean isTarantulaBossEgg(@NotNull class_1531 as) {
        if (as.method_5807() || !as.method_6084(class_1304.field_6169)) {
            return false;
        }
        String headTexture = ItemUtils.getHeadTexture(as.method_6118(class_1304.field_6169));
        if (headTexture.isBlank()) {
            return false;
        }
        return headTexture.equals("eyJ0aW1lc3RhbXAiOjE1ODMxMjMyODkwNTMsInByb2ZpbGVJZCI6IjkxZjA0ZmU5MGYzNjQzYjU4ZjIwZTMzNzVmODZkMzllIiwicHJvZmlsZU5hbWUiOiJTdG9ybVN0b3JteSIsInNpZ25hdHVyZVJlcXVpcmVkIjp0cnVlLCJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNGNlYjBlZDhmYzIyNzJiM2QzZDgyMDY3NmQ1MmEzOGU3YjJlOGRhOGM2ODdhMjMzZTBkYWJhYTE2YzBlOTZkZiJ9fX0=");
    }
}

