/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.stonks;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.core.data.hypixel.HypixelDataSource;
import fr.siroz.cariboustonks.core.data.hypixel.bazaar.BazaarProduct;
import fr.siroz.cariboustonks.core.data.hypixel.item.SkyBlockItem;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.feature.stonks.StonksScreen;
import fr.siroz.cariboustonks.manager.command.CommandComponent;
import fr.siroz.cariboustonks.util.Client;
import fr.siroz.cariboustonks.util.ItemLookupKey;
import fr.siroz.cariboustonks.util.NotEnoughUpdatesUtils;
import fr.siroz.cariboustonks.util.StonksUtils;
import fr.siroz.cariboustonks.util.colors.Colors;
import java.util.Optional;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientWorldEvents;
import net.minecraft.class_124;
import net.minecraft.class_2172;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public class StonksCommandFeature
extends Feature {
    private static final String SEPARATOR = "\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac";
    private final HypixelDataSource hypixelDataSource = CaribouStonks.core().getHypixelDataSource();
    private String lastItem = "";

    public StonksCommandFeature() {
        ClientWorldEvents.AFTER_CLIENT_WORLD_CHANGE.register((_mc, _world) -> {
            this.lastItem = "";
        });
        this.addComponent(CommandComponent.class, d -> d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"stonks").executes(context -> {
            if (this.lastItem != null && !this.lastItem.isBlank()) {
                ((FabricClientCommandSource)context.getSource()).getClient().method_1507((class_437)StonksScreen.create(ItemLookupKey.of(NotEnoughUpdatesUtils.getNeuIdFromSkyBlockId(this.lastItem), this.lastItem)));
            }
            return 1;
        })).then(ClientCommandManager.argument((String)"item", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(this.hypixelDataSource.getSkyBlockItemsIds(), (SuggestionsBuilder)builder)).executes(context -> this.handle((FabricClientCommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"item"))))));
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock();
    }

    private int handle(FabricClientCommandSource source, String item) {
        int result = 1;
        if (this.hypixelDataSource.isBazaarInUpdate()) {
            source.sendFeedback((class_2561)class_2561.method_43470((String)"Bazaar is currently updating.. Retry in few seconds.").method_27692(class_124.field_1061));
            return result;
        }
        if (!this.hypixelDataSource.hasBazaarItem(item)) {
            source.sendFeedback((class_2561)class_2561.method_43470((String)("Unable to find '" + item + "' item in the Bazaar.")).method_27692(class_124.field_1061));
            return result;
        }
        Optional<BazaarProduct> productOptional = this.hypixelDataSource.getBazaarItem(item);
        productOptional.ifPresent(product -> {
            this.lastItem = item;
            this.showBazaarInfo(source, item, (BazaarProduct)product);
        });
        return result;
    }

    private void showBazaarInfo(@NotNull FabricClientCommandSource source, @NotNull String item, @NotNull BazaarProduct bazaarProduct) {
        Client.playSound(class_3417.field_50098, 1.0f, 1.0f);
        source.sendFeedback((class_2561)class_2561.method_43470((String)SEPARATOR).method_27692(class_124.field_1061));
        SkyBlockItem skyBlockItem = this.hypixelDataSource.getSkyBlockItem(item);
        if (skyBlockItem == null) {
            source.sendFeedback((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"\u2b50").method_54663(Colors.ORANGE.asInt())).method_27693(" " + String.valueOf(class_2561.method_43470((String)(bazaarProduct.skyBlockId() + " :")).method_27692(class_124.field_1065))));
        } else {
            source.sendFeedback((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"\u2b50").method_54663(Colors.ORANGE.asInt())).method_10852((class_2561)class_2561.method_43470((String)(" " + skyBlockItem.name())).method_54663(skyBlockItem.tier().getColor())).method_10852((class_2561)class_2561.method_43470((String)(" (" + bazaarProduct.skyBlockId() + ")")).method_27692(class_124.field_1063)));
        }
        source.sendFeedback((class_2561)class_2561.method_43473());
        double buyPrice = bazaarProduct.buyPrice();
        double buyAvgPrice = bazaarProduct.weightedAverageBuyPrice();
        double buyVelocity = bazaarProduct.buyVelocity();
        double standardDeviationBuy = bazaarProduct.buyPriceStdDev();
        source.sendFeedback((class_2561)class_2561.method_43470((String)"Buy: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(StonksUtils.INTEGER_NUMBERS.format(buyPrice) + " Coins")).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(buyPrice)).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)" (Hover)").method_27692(class_124.field_1075)).method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Buy-Avg: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(StonksUtils.INTEGER_NUMBERS.format(buyAvgPrice) + " Coins")).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(buyAvgPrice)).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"\n\n")).method_10852((class_2561)class_2561.method_43470((String)"Velocity: ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.FLOAT_NUMBERS.format(buyVelocity)).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43470((String)"(Compares current volume to the daily average from the past week)").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43470((String)"- < 0.5    = Very low activity").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43470((String)"- 0.5-1.5 = Normal activity").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43470((String)"- 1.5-3   = High activity (growing interest)").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43470((String)"- > 3      = Peak activity (event, speculation)").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"\n\n")).method_10852((class_2561)class_2561.method_43470((String)"*Standard Deviation: ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(standardDeviationBuy)).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43470((String)"(This measures price volatility. Higher values indicate stronger fluctuations)").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)"\n\n")).method_10852((class_2561)class_2561.method_43470((String)"* Not a true representation of all orders").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}))))));
        long buyVolume = bazaarProduct.buyVolume();
        long buyOrders = bazaarProduct.buyOrders();
        long buyMovingWeek = bazaarProduct.buyMovingWeek();
        source.sendFeedback((class_2561)class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(buyVolume)).method_27692(class_124.field_1063).method_27693(" in " + StonksUtils.SHORT_FLOAT_NUMBERS.format(buyOrders) + " orders").method_10852((class_2561)class_2561.method_43470((String)" | ").method_27692(class_124.field_1080)).method_27693(StonksUtils.SHORT_FLOAT_NUMBERS.format(buyMovingWeek)).method_27692(class_124.field_1063).method_10852((class_2561)class_2561.method_43470((String)" insta-buys in 7d").method_27692(class_124.field_1063)));
        source.sendFeedback((class_2561)class_2561.method_43473());
        double sellPrice = bazaarProduct.sellPrice();
        double sellAvgPrice = bazaarProduct.weightedAverageSellPrice();
        double sellVelocity = bazaarProduct.sellVelocity();
        double standardDeviationSell = bazaarProduct.sellPriceStdDev();
        source.sendFeedback((class_2561)class_2561.method_43470((String)"Sell: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(StonksUtils.INTEGER_NUMBERS.format(sellPrice) + " Coins")).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(sellPrice)).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)" (Hover)").method_27692(class_124.field_1075)).method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Sell-Avg: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(StonksUtils.INTEGER_NUMBERS.format(sellAvgPrice) + " Coins")).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(sellAvgPrice)).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"\n\n")).method_10852((class_2561)class_2561.method_43470((String)"Velocity: ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.FLOAT_NUMBERS.format(sellVelocity)).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43470((String)"(Compares current volume to the daily average from the past week)").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43470((String)"- < 0.5    = Very low activity").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43470((String)"- 0.5-1.5 = Normal activity").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43470((String)"- 1.5-3   = High activity (growing interest)").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43470((String)"- > 3      = Peak activity (event, speculation)").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"\n\n")).method_10852((class_2561)class_2561.method_43470((String)"*Standard Deviation: ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(standardDeviationSell)).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43470((String)"(This measures price volatility. Higher values indicate stronger fluctuations)").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)"\n\n")).method_10852((class_2561)class_2561.method_43470((String)"* Not a true representation of all orders").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}))))));
        long sellVolume = bazaarProduct.sellVolume();
        long sellOrders = bazaarProduct.sellOrders();
        long sellMovingWeek = bazaarProduct.sellMovingWeek();
        source.sendFeedback((class_2561)class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(sellVolume)).method_27692(class_124.field_1063).method_27693(" in " + StonksUtils.SHORT_FLOAT_NUMBERS.format(sellOrders) + " orders").method_10852((class_2561)class_2561.method_43470((String)" | ").method_27692(class_124.field_1080)).method_27693(StonksUtils.SHORT_FLOAT_NUMBERS.format(sellMovingWeek)).method_27692(class_124.field_1063).method_10852((class_2561)class_2561.method_43470((String)" insta-sells in 7d").method_27692(class_124.field_1063)));
        source.sendFeedback((class_2561)class_2561.method_43473());
        double spread = bazaarProduct.spread();
        double spreadPercentage = bazaarProduct.spreadPercentage();
        source.sendFeedback((class_2561)class_2561.method_43470((String)"Spreed: ").method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)(StonksUtils.FLOAT_NUMBERS.format(spreadPercentage) + "%")).method_54663(Colors.RED.asInt())).method_10852((class_2561)class_2561.method_43470((String)" | ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.INTEGER_NUMBERS.format(spread)).method_54663(Colors.RED.asInt())).method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(spread)).method_54663(Colors.RED.asInt())).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1080)));
        source.sendFeedback((class_2561)class_2561.method_43473());
        source.sendFeedback((class_2561)class_2561.method_43470((String)" Click HERE to show in the Graph Screen!").method_27692(class_124.field_1054).method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to open in the Graph Screen!").method_27692(class_124.field_1054))).method_10958((class_2558)new class_2558.class_10609("/stonks"))));
        source.sendFeedback((class_2561)class_2561.method_43470((String)SEPARATOR).method_27692(class_124.field_1061));
    }
}

