/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.stonks;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.core.data.generic.ItemPrice;
import fr.siroz.cariboustonks.core.data.hypixel.HypixelDataSource;
import fr.siroz.cariboustonks.core.data.hypixel.bazaar.BazaarProduct;
import fr.siroz.cariboustonks.core.data.hypixel.item.SkyBlockItem;
import fr.siroz.cariboustonks.feature.stonks.graph.ItemGraphWidget;
import fr.siroz.cariboustonks.feature.stonks.info.ItemInformationWidget;
import fr.siroz.cariboustonks.feature.stonks.search.StonksSearchScreen;
import fr.siroz.cariboustonks.screen.CaribousStonksScreen;
import fr.siroz.cariboustonks.util.ItemLookupKey;
import fr.siroz.cariboustonks.util.colors.Colors;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7413;
import net.minecraft.class_7842;
import net.minecraft.class_7843;
import net.minecraft.class_7845;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8132;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class StonksScreen
extends CaribousStonksScreen {
    private static final class_2960 MENU_LIST_BACKGROUND_TEXTURE = class_2960.method_60656((String)"textures/gui/inworld_menu_list_background.png");
    private final class_1799 icon;
    private final class_2561 itemName;
    private ItemInformationWidget itemInformationWidget;
    private ItemGraphWidget itemGraphWidget;
    private List<ItemPrice> graphData = null;
    private BazaarProduct bazaarItem = null;
    private volatile boolean notFound = false;

    private StonksScreen(@NotNull ItemLookupKey key) {
        super((class_2561)class_2561.method_43470((String)"Stonks"));
        HypixelDataSource hypixelDataSource = CaribouStonks.core().getHypixelDataSource();
        Optional<SkyBlockItem> item = hypixelDataSource.getSkyBlockItemOptional(key.hypixelSkyBlockId());
        if (item.isPresent()) {
            this.itemName = class_2561.method_43470((String)item.get().name()).method_27692(item.get().tier().getFormatting());
            this.icon = hypixelDataSource.getItemStack(item.get().skyBlockId());
        } else {
            this.itemName = class_2561.method_43470((String)(key.hypixelSkyBlockId() != null ? key.hypixelSkyBlockId() : "? ? ?"));
            this.icon = new class_1799((class_1935)class_1802.field_8077);
        }
        this.fetchItemData(key).thenRun(this::initStonksWidgets);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static StonksScreen create(@NotNull ItemLookupKey key) {
        return new StonksScreen(key);
    }

    private void initStonksWidgets() {
        if (this.notFound) {
            return;
        }
        CompletableFuture<Void> graphFuture = CompletableFuture.runAsync(() -> {
            this.itemGraphWidget = new ItemGraphWidget(this.graphData, this.getGraphWidgetWidth(), this.getGraphWidgetHeight());
        });
        CompletableFuture<Void> informationsFuture = CompletableFuture.runAsync(() -> {
            this.itemInformationWidget = new ItemInformationWidget(this.bazaarItem, this.getInformationWidgetWidth(), this.getInformationWidgetHeight());
        });
        CompletableFuture.allOf(graphFuture, informationsFuture).thenRun(() -> {
            StonksScreen stonksScreen = this;
            synchronized (stonksScreen) {
                this.method_41843();
            }
        });
    }

    @Override
    protected void onInit() {
        class_8132 header = new class_8132((class_437)this, 30, 0);
        class_2561 headerText = this.graphData != null ? this.itemName : class_2561.method_43470((String)"...").method_27692(class_124.field_1068);
        header.method_48992((class_8021)new IconTextWidget(headerText, this.field_22793, this.icon));
        class_7845 gridWidget = new class_7845();
        gridWidget.method_46458().method_46477(5).method_46479(2);
        class_7845.class_7939 adder = gridWidget.method_47610(3);
        class_5250 granularity = this.itemGraphWidget != null ? class_2561.method_43470((String)this.itemGraphWidget.getGranularity()).method_27692(class_124.field_1060) : class_2561.method_43470((String)"?").method_27692(class_124.field_1067);
        class_4185 graphType = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Graph type : ").method_10852((class_2561)granularity), b -> {
            if (this.itemGraphWidget != null && this.itemGraphWidget.updateGranularity()) {
                this.method_48640();
            }
        }).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Change Graph Display").method_27693("\n\n").method_27693("Hour: Price of 1 hour").method_27693("\n").method_27693("Day: Price of 1 day").method_27693("\n").method_27693("Week: Price of 1 week").method_27693("\n").method_27693("Month: Price of 1 month"))).method_46431();
        adder.method_47612((class_8021)graphType);
        class_4185 search = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Search an item.."), _b -> Objects.requireNonNull(this.field_22787).method_1507((class_437)new StonksSearchScreen(null))).method_46431();
        adder.method_47612((class_8021)search);
        class_4185 buttonDone = class_4185.method_46430((class_2561)class_5244.field_24334, _b -> this.method_25419()).method_46431();
        adder.method_47612((class_8021)buttonDone);
        gridWidget.method_48222();
        class_7843.method_46442((class_8021)gridWidget, (int)0, (int)(this.field_22790 - 64), (int)this.field_22789, (int)64);
        gridWidget.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        header.method_48222();
        header.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRender(class_332 context, int mouseX, int mouseY, float delta) {
        StonksScreen stonksScreen = this;
        synchronized (stonksScreen) {
            super.onRender(context, mouseX, mouseY, delta);
        }
        if (this.graphData == null) {
            if (this.notFound) {
                class_5250 error = class_2561.method_43470((String)"Error ;(");
                int x1 = (this.getBackgroundWidth() - this.field_22793.method_27525((class_5348)error)) / 2;
                int y1 = this.getBackgroundHeight() / 2;
                context.method_27535(this.field_22793, (class_2561)error, x1, y1, Color.RED.getRGB());
            } else {
                this.showLoadingScreen(context);
            }
        }
        context.method_25290(class_10799.field_56883, MENU_LIST_BACKGROUND_TEXTURE, this.getBackgroundX(), this.getBackgroundY(), (float)this.getBackgroundRight(), (float)this.getBackgroundBottom(), this.field_22789, this.getBackgroundHeight(), 32, 32);
        context.method_25290(class_10799.field_56883, class_437.field_49897, this.getBackgroundX(), this.getBackgroundY() - 2, 0.0f, 0.0f, this.getBackgroundWidth(), 2, 32, 2);
        context.method_25290(class_10799.field_56883, class_437.field_49898, this.getBackgroundX(), this.getBackgroundBottom(), 0.0f, 0.0f, this.getBackgroundWidth(), 2, 32, 2);
        if (this.itemGraphWidget != null) {
            this.itemGraphWidget.updateWidgetPosition(this.getGraphWidgetWidth(), this.getGraphWidgetHeight());
            this.itemGraphWidget.render(context, mouseX, mouseY, this.getBackgroundX(), this.getBackgroundY());
        }
        if (this.itemInformationWidget != null) {
            this.itemInformationWidget.updateWidgetPosition(this.getInformationWidgetWidth(), this.getInformationWidgetHeight());
            this.itemInformationWidget.render(context, mouseX, mouseY, this.getBackgroundWidth() / 2 + 50, this.getBackgroundY());
        }
    }

    @Override
    public void onClose() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(null);
        }
    }

    private void showLoadingScreen(class_332 context) {
        if (this.field_22787 == null || this.field_22787.field_1755 == null) {
            return;
        }
        class_5250 loadingText = class_2561.method_43470((String)"Loading..");
        int x1 = (this.field_22787.field_1755.field_22789 - this.field_22793.method_27525((class_5348)loadingText)) / 2;
        int y1 = this.getBackgroundHeight() / 2;
        context.method_27535(this.field_22793, (class_2561)loadingText, x1, y1, Colors.WHITE.asInt());
        String string = class_7413.method_43449((long)class_156.method_658());
        int x2 = (this.field_22787.field_1755.field_22789 - this.field_22793.method_1727(string)) / 2;
        int y2 = y1 + 9;
        context.method_25303(this.field_22793, string, x2, y2, Colors.WHITE.asInt());
    }

    @NotNull
    private CompletableFuture<Void> fetchItemData(@NotNull ItemLookupKey key) {
        CompletionStage priceHistory = CaribouStonks.core().getGenericDataSource().loadGraphData(key).thenAccept(data -> {
            if (data == null || data.isEmpty()) {
                this.notFound = true;
            }
            this.graphData = data;
        });
        this.bazaarItem = CaribouStonks.core().getHypixelDataSource().getBazaarItem(key.hypixelSkyBlockId()).orElse(null);
        return CompletableFuture.allOf(new CompletableFuture[]{priceHistory});
    }

    private int getBackgroundX() {
        return 0;
    }

    private int getBackgroundY() {
        return 32;
    }

    private int getBackgroundWidth() {
        return this.field_22789;
    }

    private int getBackgroundHeight() {
        return this.field_22790 - 96;
    }

    private int getBackgroundRight() {
        return this.field_22789;
    }

    private int getBackgroundBottom() {
        return 32 + (this.field_22790 - 96);
    }

    private int getGraphWidgetWidth() {
        return this.getBackgroundWidth() - 30;
    }

    private int getGraphWidgetHeight() {
        return (int)((double)this.getBackgroundHeight() * 1.5);
    }

    private int getInformationWidgetWidth() {
        return this.getBackgroundWidth() - this.getBackgroundWidth() / 2 + 50;
    }

    private int getInformationWidgetHeight() {
        return (int)((double)this.getBackgroundHeight() * 1.5);
    }

    private static class IconTextWidget
    extends class_7842 {
        private final class_1799 icon;

        IconTextWidget(class_2561 message, class_327 textRenderer, class_1799 icon) {
            super(message, textRenderer);
            this.icon = icon;
        }

        public void method_48579(@NotNull class_332 context, int mouseX, int mouseY, float delta) {
            class_2561 text = this.method_25369();
            class_327 textRenderer = this.method_48977();
            int width = this.method_25368();
            int textWidth = textRenderer.method_27525((class_5348)text);
            float horizontalAlignment = 0.5f;
            int x = this.method_46426() + 17 + Math.round(horizontalAlignment * (float)(width - textWidth));
            int n = this.method_46427();
            int n2 = this.method_25364();
            Objects.requireNonNull(textRenderer);
            int y = n + (n2 - 9) / 2;
            class_5481 orderedText = textWidth > width ? this.trim(text, width) : text.method_30937();
            context.method_35720(textRenderer, orderedText, x, y, this.method_48979());
            context.method_51427(this.icon, x - 34, y - 4);
        }

        private class_5481 trim(class_2561 text, int width) {
            class_327 textRenderer = this.method_48977();
            class_5348 stringVisitable = textRenderer.method_1714((class_5348)text, width - textRenderer.method_27525((class_5348)class_5244.field_39678));
            return class_2477.method_10517().method_30934(class_5348.method_29433((class_5348[])new class_5348[]{stringVisitable, class_5244.field_39678}));
        }
    }
}

