/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.stonks.tooltips.bazaar;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.data.hypixel.HypixelDataSource;
import fr.siroz.cariboustonks.core.data.hypixel.bazaar.BazaarProduct;
import fr.siroz.cariboustonks.core.skyblock.AttributeAPI;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.feature.stonks.tooltips.TooltipPriceDisplayType;
import fr.siroz.cariboustonks.feature.stonks.tooltips.bazaar.BazaarTooltipPriceType;
import fr.siroz.cariboustonks.manager.container.ContainerMatcherTrait;
import fr.siroz.cariboustonks.manager.container.tooltip.ContainerTooltipAppender;
import fr.siroz.cariboustonks.util.StonksUtils;
import fr.siroz.cariboustonks.util.colors.Colors;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_9322;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BazaarPriceTooltipFeature
extends Feature
implements ContainerMatcherTrait,
ContainerTooltipAppender {
    private final HypixelDataSource hypixelDataSource;
    private final int priority;

    public BazaarPriceTooltipFeature(int priority) {
        this.priority = priority;
        this.hypixelDataSource = CaribouStonks.core().getHypixelDataSource();
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock() && ConfigManager.getConfig().general.stonks.bazaarTooltipPrice;
    }

    @Override
    @Nullable
    public Pattern getTitlePattern() {
        return null;
    }

    @Override
    public void appendToTooltip(@Nullable class_1735 focusedSlot, @NotNull class_1799 item, @NotNull List<class_2561> lines) {
        if (this.hypixelDataSource.isBazaarInUpdate()) {
            lines.add((class_2561)class_2561.method_43470((String)"Bazaar is currently updating...").method_27692(class_124.field_1061));
            return;
        }
        String skyBlockApiId = SkyBlockAPI.getSkyBlockApiId((class_9322)item);
        if (this.hypixelDataSource.hasBazaarItem(skyBlockApiId = AttributeAPI.getSkyBlockApiIdFromNewShard(skyBlockApiId, item, lines))) {
            Optional<BazaarProduct> product = this.hypixelDataSource.getBazaarItem(skyBlockApiId);
            if (product.isEmpty()) {
                lines.add((class_2561)class_2561.method_43470((String)"Bazaar item error.").method_27692(class_124.field_1061));
                return;
            }
            int count = item.method_7947();
            BazaarTooltipPriceType bazaarTooltipPriceType = ConfigManager.getConfig().general.stonks.bazaarTooltipPriceType;
            int n = 0;
            switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"ALL", "NORMAL", "AVERAGE"}, (BazaarTooltipPriceType)bazaarTooltipPriceType, n)) {
                case 0: {
                    this.addBazaarLine(lines, "Bazaar Buy: ", product.get().buyPrice(), count);
                    this.addBazaarLine(lines, "Bazaar Sell: ", product.get().sellPrice(), count);
                    this.addBazaarLine(lines, "Bazaar Buy-Avg: ", product.get().weightedAverageBuyPrice(), 1);
                    this.addBazaarLine(lines, "Bazaar Sell-Avg: ", product.get().weightedAverageSellPrice(), 1);
                    if (class_437.method_25442() || count <= 1) break;
                    lines.add((class_2561)class_2561.method_43470((String)("[Press SHIFT for x" + count + "]")).method_27692(class_124.field_1063));
                    break;
                }
                case 1: {
                    this.addBazaarLine(lines, "Bazaar Buy: ", product.get().buyPrice(), count);
                    this.addBazaarLine(lines, "Bazaar Sell: ", product.get().sellPrice(), count);
                    if (class_437.method_25442() || count <= 1) break;
                    lines.add((class_2561)class_2561.method_43470((String)("[Press SHIFT for x" + count + "]")).method_27692(class_124.field_1063));
                    break;
                }
                case 2: {
                    this.addBazaarLine(lines, "Bazaar Buy-Avg: ", product.get().weightedAverageBuyPrice(), 1);
                    this.addBazaarLine(lines, "Bazaar Sell-Avg: ", product.get().weightedAverageSellPrice(), 1);
                    break;
                }
            }
            if (ConfigManager.getConfig().general.stonks.bazaarTooltipMoreData) {
                double absoluteSpread = product.get().spread();
                double spreadPercentage = product.get().spreadPercentage();
                class_5250 spread = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)" | Spreed: ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)(StonksUtils.FLOAT_NUMBERS.format(spreadPercentage) + "%")).method_54663(Colors.RED.asInt())).method_10852((class_2561)class_2561.method_43470((String)" | ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.INTEGER_NUMBERS.format(absoluteSpread)).method_54663(Colors.RED.asInt())).method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(absoluteSpread)).method_54663(Colors.RED.asInt())).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1080));
                lines.add((class_2561)spread);
            }
        }
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    private void addBazaarLine(@NotNull List<class_2561> lines, @NotNull String label, double value, int count) {
        String display;
        if (value < 0.0) {
            lines.add((class_2561)class_2561.method_43470((String)label).method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)" No Data").method_27692(class_124.field_1061)));
            return;
        }
        TooltipPriceDisplayType displayType = ConfigManager.getConfig().general.stonks.bazaarTooltipPriceDisplayType;
        if (value < 100.0) {
            display = StonksUtils.FLOAT_NUMBERS.format(value);
        } else {
            if (class_437.method_25442() && count > 1) {
                value *= (double)count;
            }
            display = displayType == TooltipPriceDisplayType.SHORT ? StonksUtils.SHORT_FLOAT_NUMBERS.format(value) : StonksUtils.INTEGER_NUMBERS.format(value);
        }
        TooltipPriceDisplayType tooltipPriceDisplayType = displayType;
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"FULL", "SHORT", "ALL"}, (TooltipPriceDisplayType)tooltipPriceDisplayType, n)) {
            case 0: 
            case 1: {
                lines.add((class_2561)class_2561.method_43470((String)label).method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(display + " Coins")).method_27692(class_124.field_1065)));
                break;
            }
            case 2: {
                lines.add((class_2561)class_2561.method_43470((String)label).method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(display + " Coins")).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)StonksUtils.SHORT_FLOAT_NUMBERS.format(value)).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1080)));
                break;
            }
        }
    }
}

