/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.ui.hud;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.manager.hud.Hud;
import fr.siroz.cariboustonks.manager.hud.HudProvider;
import fr.siroz.cariboustonks.manager.hud.TextHud;
import fr.siroz.cariboustonks.manager.network.NetworkManager;
import it.unimi.dsi.fastutil.Pair;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class TpsHud
extends Feature
implements HudProvider {
    private static final class_2960 HUD_ID = CaribouStonks.identifier("hud_tps");
    private final Hud hud;
    private final NetworkManager networkManager = CaribouStonks.managers().getManager(NetworkManager.class);
    private int lastTruncatedTps = -1;
    private String cachedText = null;

    public TpsHud() {
        this.hud = new TextHud((class_2561)class_2561.method_43470((String)"TPS: 20.0"), this::getText, ConfigManager.getConfig().uiAndVisuals.tpsHud, 6, 8);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    @NotNull
    public Pair<class_2960, class_2960> getAttachLayerAfter() {
        return Pair.of((Object)VanillaHudElements.STATUS_EFFECTS, (Object)HUD_ID);
    }

    @Override
    @NotNull
    public Hud getHud() {
        return this.hud;
    }

    private class_2561 getText() {
        float tps = this.networkManager.getTickRate();
        int truncatedTps = (int)(tps * 10.0f);
        if (truncatedTps != this.lastTruncatedTps) {
            int integerPart = truncatedTps / 10;
            int decimalPart = truncatedTps % 10;
            this.cachedText = "TPS: " + integerPart + "." + decimalPart;
            this.lastTruncatedTps = truncatedTps;
        }
        int textColor = this.getTickRateColor(tps) | 0xFF000000;
        return class_2561.method_43470((String)this.cachedText).method_27694(style -> style.method_36139(textColor));
    }

    private int getTickRateColor(float tps) {
        if (tps >= 19.55f) {
            return 8778384;
        }
        if (tps >= 17.72f) {
            return 15528581;
        }
        return 16735345;
    }
}

