/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.vanilla;

import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.event.MouseEvents;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.manager.keybinds.KeyBind;
import fr.siroz.cariboustonks.manager.keybinds.KeyBindComponent;
import java.util.Collections;

public final class ZoomFeature
extends Feature {
    private static final double ZOOM_MULTIPLIER = 0.3;
    private static final double ZOOM_STEP = 0.05;
    private static final double MIN_ZOOM = 0.05;
    private static final double MAX_ZOOM = 1.0;
    private final KeyBind zoomKeyBind = new KeyBind("Zoom", 67, true);
    private double currentZoomMultiplier = 0.3;

    public ZoomFeature() {
        MouseEvents.ALLOW_MOUSE_SCROLL.register(this::allowMouseScroll);
        this.addComponent(KeyBindComponent.class, () -> Collections.singletonList(this.zoomKeyBind));
    }

    @Override
    public boolean isEnabled() {
        return ConfigManager.getConfig().vanilla.zoom.enabled;
    }

    public boolean isZooming() {
        if (!this.isEnabled()) {
            return false;
        }
        return this.zoomKeyBind.isPressed();
    }

    public double getCurrentZoomMultiplier() {
        return this.currentZoomMultiplier;
    }

    public void resetZoomMultiplier() {
        this.currentZoomMultiplier = 0.3;
    }

    private boolean allowMouseScroll(double horizontal, double vertical) {
        if (!this.isZooming()) {
            return true;
        }
        if (!ConfigManager.getConfig().vanilla.zoom.mouseScrolling) {
            return true;
        }
        if (vertical > 0.0) {
            this.decreaseZoom();
        } else if (vertical < 0.0) {
            this.increaseZoom();
        }
        return false;
    }

    private void decreaseZoom() {
        this.currentZoomMultiplier = Math.max(0.05, this.currentZoomMultiplier - 0.05);
    }

    private void increaseZoom() {
        this.currentZoomMultiplier = Math.min(1.0, this.currentZoomMultiplier + 0.05);
    }
}

