/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.manager.container.tooltip;

import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.core.crash.CrashType;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.manager.Manager;
import fr.siroz.cariboustonks.manager.container.ContainerMatcherTrait;
import fr.siroz.cariboustonks.manager.container.tooltip.ContainerTooltipAppender;
import fr.siroz.cariboustonks.mixin.accessors.HandledScreenAccessor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class ContainerTooltipAppenderManager
implements Manager {
    private final Map<Feature, ContainerTooltipAppender> tooltipAppenderMap = new LinkedHashMap<Feature, ContainerTooltipAppender>();
    private final List<ContainerTooltipAppender> currentContainerTooltips = new ArrayList<ContainerTooltipAppender>();

    @ApiStatus.Internal
    public ContainerTooltipAppenderManager() {
        ItemTooltipCallback.EVENT.register(this::onTooltipCallback);
        ScreenEvents.AFTER_INIT.register(this::onAfterInit);
    }

    @Override
    public void register(@NotNull Feature feature) {
        if (feature instanceof ContainerTooltipAppender) {
            ContainerTooltipAppender containerTooltipAppender = (ContainerTooltipAppender)((Object)feature);
            this.tooltipAppenderMap.put(feature, containerTooltipAppender);
        }
    }

    private void onTooltipCallback(class_1799 stack, class_1792.class_9635 tooltipContext, class_1836 tooltipType, List<class_2561> lines) {
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof class_465) {
            class_465 handledScreen = (class_465)class_4372;
            this.appendToTooltip(((HandledScreenAccessor)handledScreen).getFocusedSlot(), stack, lines);
        } else {
            this.appendToTooltip(null, stack, lines);
        }
    }

    private void onAfterInit(class_310 minecraftClient, class_437 screen, int scaledWidth, int scaledHeight) {
        this.currentContainerTooltips.clear();
        for (Map.Entry<Feature, ContainerTooltipAppender> appender : this.tooltipAppenderMap.entrySet()) {
            ContainerMatcherTrait trait;
            Feature feature;
            if (!appender.getKey().isEnabled() || !((feature = appender.getKey()) instanceof ContainerMatcherTrait) || !(trait = (ContainerMatcherTrait)((Object)feature)).matches(screen)) continue;
            this.currentContainerTooltips.add(appender.getValue());
        }
        this.currentContainerTooltips.sort(Comparator.comparingInt(ContainerTooltipAppender::getPriority));
        ScreenEvents.remove((class_437)screen).register(_screen -> this.currentContainerTooltips.clear());
    }

    private void appendToTooltip(class_1735 focusedSlot, class_1799 stack, List<class_2561> lines) {
        if (!SkyBlockAPI.isOnSkyBlock()) {
            return;
        }
        for (ContainerTooltipAppender appender : this.currentContainerTooltips) {
            try {
                appender.appendToTooltip(focusedSlot, stack, lines);
            }
            catch (Throwable throwable) {
                CaribouStonks.core().getCrashManager().reportCrash(CrashType.CONTAINER, appender.getClass().getSimpleName(), appender.getClass().getName(), "appendToTooltip", throwable);
            }
        }
    }
}

