/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.manager.hud;

import fr.siroz.cariboustonks.manager.hud.Hud;
import fr.siroz.cariboustonks.manager.hud.HudConfig;
import fr.siroz.cariboustonks.util.colors.Colors;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_9779;
import org.jetbrains.annotations.NotNull;

public final class TextHud
extends Hud {
    private final class_2561 defaultText;
    private final Supplier<class_2561> textSupplier;

    public TextHud(@NotNull class_2561 defaultText, @NotNull Supplier<class_2561> textSupplier, @NotNull HudConfig hudConfig, int defaultX, int defaultY) {
        super(() -> true, hudConfig, defaultX, defaultY);
        this.defaultText = defaultText;
        this.textSupplier = textSupplier;
    }

    @Override
    public int width() {
        return (int)((float)TextHud.CLIENT.field_1772.method_27525((class_5348)this.defaultText) * this.scale());
    }

    @Override
    public int height() {
        Objects.requireNonNull(TextHud.CLIENT.field_1772);
        return (int)(9.0f * this.scale());
    }

    @Override
    public void renderScreen(class_332 context) {
        this.render(this.defaultText, context, this.x(), this.y(), this.scale());
    }

    @Override
    public void renderHud(class_332 context, class_9779 tickCounter) {
        class_2561 text = this.textSupplier.get();
        if (this.shouldRender() && !text.getString().isEmpty()) {
            this.render(text, context, this.hudConfig.x(), this.hudConfig.y(), this.hudConfig.scale());
        }
    }

    private void render(class_2561 text, @NotNull class_332 context, int x, int y, float scale) {
        context.method_51448().pushMatrix();
        context.method_51448().scale(scale, scale);
        context.method_51439(TextHud.CLIENT.field_1772, text, (int)((float)x / scale), (int)((float)y / scale), Colors.WHITE.asInt(), false);
        context.method_51448().popMatrix();
    }
}

