/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.manager.waypoint.options;

import java.util.Optional;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public final class TextOption {
    private class_2561 text;
    private final boolean withDistance;
    private final int offsetY;
    private final boolean throughBlocks;

    public TextOption() {
        this(null, false, -1, true);
    }

    private TextOption(class_2561 text, boolean withDistance, int offsetY, boolean throughBlocks) {
        this.text = text;
        this.withDistance = withDistance;
        this.offsetY = offsetY;
        this.throughBlocks = throughBlocks;
    }

    @Contract(pure=true)
    @NotNull
    public Optional<class_2561> getText() {
        return Optional.ofNullable(this.text);
    }

    public void updateText(@Nullable class_2561 text) {
        this.text = text;
    }

    public boolean isWithDistance() {
        return this.withDistance;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public boolean isThroughBlocks() {
        return this.throughBlocks;
    }

    @Contract(value=" -> new")
    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        protected class_2561 text = null;
        protected boolean withDistance = false;
        protected int offsetY = -1;
        protected boolean throughBlocks = true;

        public Builder withText(@Nullable class_2561 text) {
            this.text = text;
            return this;
        }

        public Builder withDistance(boolean withDistance) {
            this.withDistance = withDistance;
            return this;
        }

        public Builder withOffsetY(@Range(from=1L, to=100L) int offsetY) {
            this.offsetY = offsetY;
            return this;
        }

        public Builder withThroughBlocks(boolean throughBlocks) {
            this.throughBlocks = throughBlocks;
            return this;
        }

        public TextOption build() {
            return new TextOption(this.text, this.withDistance, this.offsetY, this.throughBlocks);
        }
    }
}

